<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetColourTypes StructType
 * @subpackage Structs
 */
class GetColourTypes extends AbstractStructBase
{
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ArticleId;
    /**
     * The safekey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safekey;
    /**
     * Constructor method for GetColourTypes
     * @uses GetColourTypes::setArticleId()
     * @uses GetColourTypes::setSafekey()
     * @param int $articleId
     * @param string $safekey
     */
    public function __construct($articleId = null, $safekey = null)
    {
        $this
            ->setArticleId($articleId)
            ->setSafekey($safekey);
    }
    /**
     * Get ArticleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param int $articleId
     * @return \Farfetch\StructType\GetColourTypes
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get safekey value
     * @return string|null
     */
    public function getSafekey()
    {
        return $this->safekey;
    }
    /**
     * Set safekey value
     * @param string $safekey
     * @return \Farfetch\StructType\GetColourTypes
     */
    public function setSafekey($safekey = null)
    {
        // validation for constraint: string
        if (!is_null($safekey) && !is_string($safekey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safekey, true), gettype($safekey)), __LINE__);
        }
        $this->safekey = $safekey;
        return $this;
    }
}
