<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isBrandVisible
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\IsBrandVisible $parameters
     * @return \Farfetch\StructType\IsBrandVisibleResponse|bool
     */
    public function isBrandVisible(\Farfetch\StructType\IsBrandVisible $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isBrandVisible($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\IsBrandVisibleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
