<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPropValueIdByName StructType
 * @subpackage Structs
 */
class GetPropValueIdByName extends AbstractStructBase
{
    /**
     * The propid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $propid;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for GetPropValueIdByName
     * @uses GetPropValueIdByName::setPropid()
     * @uses GetPropValueIdByName::setName()
     * @uses GetPropValueIdByName::setSafeKey()
     * @param int $propid
     * @param string $name
     * @param string $safeKey
     */
    public function __construct($propid = null, $name = null, $safeKey = null)
    {
        $this
            ->setPropid($propid)
            ->setName($name)
            ->setSafeKey($safeKey);
    }
    /**
     * Get propid value
     * @return int
     */
    public function getPropid()
    {
        return $this->propid;
    }
    /**
     * Set propid value
     * @param int $propid
     * @return \Farfetch\StructType\GetPropValueIdByName
     */
    public function setPropid($propid = null)
    {
        // validation for constraint: int
        if (!is_null($propid) && !(is_int($propid) || ctype_digit($propid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propid, true), gettype($propid)), __LINE__);
        }
        $this->propid = $propid;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Farfetch\StructType\GetPropValueIdByName
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetPropValueIdByName
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
}
