<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveGeoBrandPrices StructType
 * @subpackage Structs
 */
class SaveGeoBrandPrices extends AbstractStructBase
{
    /**
     * The storeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeId;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The brandPriceInputs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfGeoBrandPriceInput
     */
    public $brandPriceInputs;
    /**
     * Constructor method for SaveGeoBrandPrices
     * @uses SaveGeoBrandPrices::setStoreId()
     * @uses SaveGeoBrandPrices::setSafeKey()
     * @uses SaveGeoBrandPrices::setBrandPriceInputs()
     * @param int $storeId
     * @param string $safeKey
     * @param \Farfetch\ArrayType\ArrayOfGeoBrandPriceInput $brandPriceInputs
     */
    public function __construct($storeId = null, $safeKey = null, \Farfetch\ArrayType\ArrayOfGeoBrandPriceInput $brandPriceInputs = null)
    {
        $this
            ->setStoreId($storeId)
            ->setSafeKey($safeKey)
            ->setBrandPriceInputs($brandPriceInputs);
    }
    /**
     * Get storeId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param int $storeId
     * @return \Farfetch\StructType\SaveGeoBrandPrices
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\SaveGeoBrandPrices
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get brandPriceInputs value
     * @return \Farfetch\ArrayType\ArrayOfGeoBrandPriceInput|null
     */
    public function getBrandPriceInputs()
    {
        return $this->brandPriceInputs;
    }
    /**
     * Set brandPriceInputs value
     * @param \Farfetch\ArrayType\ArrayOfGeoBrandPriceInput $brandPriceInputs
     * @return \Farfetch\StructType\SaveGeoBrandPrices
     */
    public function setBrandPriceInputs(\Farfetch\ArrayType\ArrayOfGeoBrandPriceInput $brandPriceInputs = null)
    {
        $this->brandPriceInputs = $brandPriceInputs;
        return $this;
    }
}
