<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoRegion StructType
 * @subpackage Structs
 */
class GeoRegion extends AbstractStructBase
{
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegionId;
    /**
     * The BrandId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BrandId;
    /**
     * The StoreId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $StoreId;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrencyId;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The IsMandatory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMandatory;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for GeoRegion
     * @uses GeoRegion::setRegionId()
     * @uses GeoRegion::setBrandId()
     * @uses GeoRegion::setStoreId()
     * @uses GeoRegion::setCurrencyId()
     * @uses GeoRegion::setType()
     * @uses GeoRegion::setIsMandatory()
     * @uses GeoRegion::setName()
     * @param int $regionId
     * @param int $brandId
     * @param int $storeId
     * @param int $currencyId
     * @param string $type
     * @param bool $isMandatory
     * @param string $name
     */
    public function __construct($regionId = null, $brandId = null, $storeId = null, $currencyId = null, $type = null, $isMandatory = null, $name = null)
    {
        $this
            ->setRegionId($regionId)
            ->setBrandId($brandId)
            ->setStoreId($storeId)
            ->setCurrencyId($currencyId)
            ->setType($type)
            ->setIsMandatory($isMandatory)
            ->setName($name);
    }
    /**
     * Get RegionId value
     * @return int
     */
    public function getRegionId()
    {
        return $this->RegionId;
    }
    /**
     * Set RegionId value
     * @param int $regionId
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: int
        if (!is_null($regionId) && !(is_int($regionId) || ctype_digit($regionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        $this->RegionId = $regionId;
        return $this;
    }
    /**
     * Get BrandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->BrandId;
    }
    /**
     * Set BrandId value
     * @param int $brandId
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->BrandId = $brandId;
        return $this;
    }
    /**
     * Get StoreId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->StoreId;
    }
    /**
     * Set StoreId value
     * @param int $storeId
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->StoreId = $storeId;
        return $this;
    }
    /**
     * Get CurrencyId value
     * @return int
     */
    public function getCurrencyId()
    {
        return $this->CurrencyId;
    }
    /**
     * Set CurrencyId value
     * @param int $currencyId
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: int
        if (!is_null($currencyId) && !(is_int($currencyId) || ctype_digit($currencyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        $this->CurrencyId = $currencyId;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsMandatory value
     * @return bool
     */
    public function getIsMandatory()
    {
        return $this->IsMandatory;
    }
    /**
     * Set IsMandatory value
     * @param bool $isMandatory
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setIsMandatory($isMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMandatory) && !is_bool($isMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMandatory, true), gettype($isMandatory)), __LINE__);
        }
        $this->IsMandatory = $isMandatory;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Farfetch\StructType\GeoRegion
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
