<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoBrandPriceInput StructType
 * @subpackage Structs
 */
class GeoBrandPriceInput extends AbstractStructBase
{
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SeasonId;
    /**
     * The BrandId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BrandId;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegionId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The DesignerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesignerId;
    /**
     * Constructor method for GeoBrandPriceInput
     * @uses GeoBrandPriceInput::setSeasonId()
     * @uses GeoBrandPriceInput::setBrandId()
     * @uses GeoBrandPriceInput::setRegionId()
     * @uses GeoBrandPriceInput::setPrice()
     * @uses GeoBrandPriceInput::setDesignerId()
     * @param int $seasonId
     * @param int $brandId
     * @param int $regionId
     * @param float $price
     * @param string $designerId
     */
    public function __construct($seasonId = null, $brandId = null, $regionId = null, $price = null, $designerId = null)
    {
        $this
            ->setSeasonId($seasonId)
            ->setBrandId($brandId)
            ->setRegionId($regionId)
            ->setPrice($price)
            ->setDesignerId($designerId);
    }
    /**
     * Get SeasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->SeasonId;
    }
    /**
     * Set SeasonId value
     * @param int $seasonId
     * @return \Farfetch\StructType\GeoBrandPriceInput
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->SeasonId = $seasonId;
        return $this;
    }
    /**
     * Get BrandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->BrandId;
    }
    /**
     * Set BrandId value
     * @param int $brandId
     * @return \Farfetch\StructType\GeoBrandPriceInput
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->BrandId = $brandId;
        return $this;
    }
    /**
     * Get RegionId value
     * @return int
     */
    public function getRegionId()
    {
        return $this->RegionId;
    }
    /**
     * Set RegionId value
     * @param int $regionId
     * @return \Farfetch\StructType\GeoBrandPriceInput
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: int
        if (!is_null($regionId) && !(is_int($regionId) || ctype_digit($regionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        $this->RegionId = $regionId;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \Farfetch\StructType\GeoBrandPriceInput
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get DesignerId value
     * @return string|null
     */
    public function getDesignerId()
    {
        return $this->DesignerId;
    }
    /**
     * Set DesignerId value
     * @param string $designerId
     * @return \Farfetch\StructType\GeoBrandPriceInput
     */
    public function setDesignerId($designerId = null)
    {
        // validation for constraint: string
        if (!is_null($designerId) && !is_string($designerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designerId, true), gettype($designerId)), __LINE__);
        }
        $this->DesignerId = $designerId;
        return $this;
    }
}
