<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for existSKU StructType
 * @subpackage Structs
 */
class ExistSKU extends AbstractStructBase
{
    /**
     * The storeid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeid;
    /**
     * The skuid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $skuid;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for existSKU
     * @uses ExistSKU::setStoreid()
     * @uses ExistSKU::setSkuid()
     * @uses ExistSKU::setSafeKey()
     * @param int $storeid
     * @param int $skuid
     * @param string $safeKey
     */
    public function __construct($storeid = null, $skuid = null, $safeKey = null)
    {
        $this
            ->setStoreid($storeid)
            ->setSkuid($skuid)
            ->setSafeKey($safeKey);
    }
    /**
     * Get storeid value
     * @return int
     */
    public function getStoreid()
    {
        return $this->storeid;
    }
    /**
     * Set storeid value
     * @param int $storeid
     * @return \Farfetch\StructType\ExistSKU
     */
    public function setStoreid($storeid = null)
    {
        // validation for constraint: int
        if (!is_null($storeid) && !(is_int($storeid) || ctype_digit($storeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeid, true), gettype($storeid)), __LINE__);
        }
        $this->storeid = $storeid;
        return $this;
    }
    /**
     * Get skuid value
     * @return int
     */
    public function getSkuid()
    {
        return $this->skuid;
    }
    /**
     * Set skuid value
     * @param int $skuid
     * @return \Farfetch\StructType\ExistSKU
     */
    public function setSkuid($skuid = null)
    {
        // validation for constraint: int
        if (!is_null($skuid) && !(is_int($skuid) || ctype_digit($skuid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($skuid, true), gettype($skuid)), __LINE__);
        }
        $this->skuid = $skuid;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\ExistSKU
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
}
