<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStock StructType
 * @subpackage Structs
 */
class GetStock extends AbstractStructBase
{
    /**
     * The storeid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeid;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for GetStock
     * @uses GetStock::setStoreid()
     * @uses GetStock::setBarcode()
     * @uses GetStock::setSafeKey()
     * @param int $storeid
     * @param string $barcode
     * @param string $safeKey
     */
    public function __construct($storeid = null, $barcode = null, $safeKey = null)
    {
        $this
            ->setStoreid($storeid)
            ->setBarcode($barcode)
            ->setSafeKey($safeKey);
    }
    /**
     * Get storeid value
     * @return int
     */
    public function getStoreid()
    {
        return $this->storeid;
    }
    /**
     * Set storeid value
     * @param int $storeid
     * @return \Farfetch\StructType\GetStock
     */
    public function setStoreid($storeid = null)
    {
        // validation for constraint: int
        if (!is_null($storeid) && !(is_int($storeid) || ctype_digit($storeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeid, true), gettype($storeid)), __LINE__);
        }
        $this->storeid = $storeid;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \Farfetch\StructType\GetStock
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetStock
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
}
