<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductTransportationProperties StructType
 * @subpackage Structs
 */
class GetProductTransportationProperties extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $productId;
    /**
     * Constructor method for GetProductTransportationProperties
     * @uses GetProductTransportationProperties::setProductId()
     * @param int $productId
     */
    public function __construct($productId = null)
    {
        $this
            ->setProductId($productId);
    }
    /**
     * Get productId value
     * @return int
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \Farfetch\StructType\GetProductTransportationProperties
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
}
