<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDesignerIdToBrandSeasonList StructType
 * @subpackage Structs
 */
class AddDesignerIdToBrandSeasonList extends AbstractStructBase
{
    /**
     * The brandid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandid;
    /**
     * The seasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $seasonId;
    /**
     * The designerIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfString
     */
    public $designerIds;
    /**
     * Constructor method for AddDesignerIdToBrandSeasonList
     * @uses AddDesignerIdToBrandSeasonList::setBrandid()
     * @uses AddDesignerIdToBrandSeasonList::setSeasonId()
     * @uses AddDesignerIdToBrandSeasonList::setDesignerIds()
     * @param int $brandid
     * @param int $seasonId
     * @param \Farfetch\ArrayType\ArrayOfString $designerIds
     */
    public function __construct($brandid = null, $seasonId = null, \Farfetch\ArrayType\ArrayOfString $designerIds = null)
    {
        $this
            ->setBrandid($brandid)
            ->setSeasonId($seasonId)
            ->setDesignerIds($designerIds);
    }
    /**
     * Get brandid value
     * @return int
     */
    public function getBrandid()
    {
        return $this->brandid;
    }
    /**
     * Set brandid value
     * @param int $brandid
     * @return \Farfetch\StructType\AddDesignerIdToBrandSeasonList
     */
    public function setBrandid($brandid = null)
    {
        // validation for constraint: int
        if (!is_null($brandid) && !(is_int($brandid) || ctype_digit($brandid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandid, true), gettype($brandid)), __LINE__);
        }
        $this->brandid = $brandid;
        return $this;
    }
    /**
     * Get seasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->seasonId;
    }
    /**
     * Set seasonId value
     * @param int $seasonId
     * @return \Farfetch\StructType\AddDesignerIdToBrandSeasonList
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->seasonId = $seasonId;
        return $this;
    }
    /**
     * Get designerIds value
     * @return \Farfetch\ArrayType\ArrayOfString|null
     */
    public function getDesignerIds()
    {
        return $this->designerIds;
    }
    /**
     * Set designerIds value
     * @param \Farfetch\ArrayType\ArrayOfString $designerIds
     * @return \Farfetch\StructType\AddDesignerIdToBrandSeasonList
     */
    public function setDesignerIds(\Farfetch\ArrayType\ArrayOfString $designerIds = null)
    {
        $this->designerIds = $designerIds;
        return $this;
    }
}
