<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://retail-ws.farfetch.com/ws/wsfarfetch.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://retail-ws.farfetch.com/ws/wsfarfetch.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Farfetch\ClassMap::get(),
);
/**
 * Samples for Update ServiceType
 */
$update = new \Farfetch\ServiceType\Update($options);
/**
 * Sample call for UpdateBoArtigosRefFar operation/method
 */
if ($update->UpdateBoArtigosRefFar(new \Farfetch\StructType\UpdateBoArtigosRefFar()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Farfetch\ServiceType\Get($options);
/**
 * Sample call for GetPossibleDuplicates operation/method
 */
if ($get->GetPossibleDuplicates(new \Farfetch\StructType\GetPossibleDuplicates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBrandRegions operation/method
 */
if ($get->GetBrandRegions(new \Farfetch\StructType\GetBrandRegions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStock operation/method
 */
if ($get->GetAllStock(new \Farfetch\StructType\GetAllStock()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStockWithStoreBarcodes operation/method
 */
if ($get->GetAllStockWithStoreBarcodes(new \Farfetch\StructType\GetAllStockWithStoreBarcodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBoxName operation/method
 */
if ($get->GetBoxName(new \Farfetch\StructType\GetBoxName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBoxes operation/method
 */
if ($get->GetBoxes(new \Farfetch\StructType\GetBoxes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDefaultCountries operation/method
 */
if ($get->GetDefaultCountries(new \Farfetch\StructType\GetDefaultCountries()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetList operation/method
 */
if ($get->GetList(new \Farfetch\StructType\GetList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetColourTypes operation/method
 */
if ($get->GetColourTypes(new \Farfetch\StructType\GetColourTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetComposition operation/method
 */
if ($get->GetComposition(new \Farfetch\StructType\GetComposition()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMainView operation/method
 */
if ($get->GetMainView(new \Farfetch\StructType\GetMainView()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMeasures operation/method
 */
if ($get->GetMeasures(new \Farfetch\StructType\GetMeasures()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPropValueNameById operation/method
 */
if ($get->GetPropValueNameById(new \Farfetch\StructType\GetPropValueNameById()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPropValueIdByName operation/method
 */
if ($get->GetPropValueIdByName(new \Farfetch\StructType\GetPropValueIdByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProperty operation/method
 */
if ($get->GetProperty(new \Farfetch\StructType\GetProperty()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSizeHelpId operation/method
 */
if ($get->GetSizeHelpId(new \Farfetch\StructType\GetSizeHelpId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSizes operation/method
 */
if ($get->GetSizes(new \Farfetch\StructType\GetSizes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStock operation/method
 */
if ($get->GetStock(new \Farfetch\StructType\GetStock()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreItems operation/method
 */
if ($get->GetStoreItems(new \Farfetch\StructType\GetStoreItems()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStorePrice operation/method
 */
if ($get->GetStorePrice(new \Farfetch\StructType\GetStorePrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebsiteDescription operation/method
 */
if ($get->GetWebsiteDescription(new \Farfetch\StructType\GetWebsiteDescription()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSKUandDesingerID operation/method
 */
if ($get->GetSKUandDesingerID(new \Farfetch\StructType\GetSKUandDesingerID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetParentItemId operation/method
 */
if ($get->GetParentItemId(new \Farfetch\StructType\GetParentItemId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFFItemId operation/method
 */
if ($get->GetFFItemId(new \Farfetch\StructType\GetFFItemId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFFItemUrl operation/method
 */
if ($get->GetFFItemUrl(new \Farfetch\StructType\GetFFItemUrl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGender operation/method
 */
if ($get->GetGender(new \Farfetch\StructType\GetGender()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMaterialCategory operation/method
 */
if ($get->GetMaterialCategory(new \Farfetch\StructType\GetMaterialCategory()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMaterial operation/method
 */
if ($get->GetMaterial(new \Farfetch\StructType\GetMaterial()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategories operation/method
 */
if ($get->GetCategories(new \Farfetch\StructType\GetCategories()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSizeRangesFiltered operation/method
 */
if ($get->GetSizeRangesFiltered(new \Farfetch\StructType\GetSizeRangesFiltered()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSlots operation/method
 */
if ($get->GetSlots(new \Farfetch\StructType\GetSlots()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOpenSlots operation/method
 */
if ($get->GetOpenSlots(new \Farfetch\StructType\GetOpenSlots()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSonId operation/method
 */
if ($get->GetSonId(new \Farfetch\StructType\GetSonId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSonIdForOrderManagement operation/method
 */
if ($get->GetSonIdForOrderManagement(new \Farfetch\StructType\GetSonIdForOrderManagement()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDesignerIdsForSeasonBrand operation/method
 */
if ($get->GetDesignerIdsForSeasonBrand(new \Farfetch\StructType\GetDesignerIdsForSeasonBrand()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllPictures operation/method
 */
if ($get->GetAllPictures(new \Farfetch\StructType\GetAllPictures()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllPicturesByBarcode operation/method
 */
if ($get->GetAllPicturesByBarcode(new \Farfetch\StructType\GetAllPicturesByBarcode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSizeRangesInUse operation/method
 */
if ($get->GetAllSizeRangesInUse(new \Farfetch\StructType\GetAllSizeRangesInUse()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransportationProperties operation/method
 */
if ($get->GetTransportationProperties(new \Farfetch\StructType\GetTransportationProperties()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductTransportationProperties operation/method
 */
if ($get->GetProductTransportationProperties(new \Farfetch\StructType\GetProductTransportationProperties()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \Farfetch\ServiceType\Save($options);
/**
 * Sample call for SaveGeoBrandPrices operation/method
 */
if ($save->SaveGeoBrandPrices(new \Farfetch\StructType\SaveGeoBrandPrices()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Associate ServiceType
 */
$associate = new \Farfetch\ServiceType\Associate($options);
/**
 * Sample call for AssociateToChildProduct operation/method
 */
if ($associate->AssociateToChildProduct(new \Farfetch\StructType\AssociateToChildProduct()) !== false) {
    print_r($associate->getResult());
} else {
    print_r($associate->getLastError());
}
/**
 * Sample call for AssociateProduct operation/method
 */
if ($associate->AssociateProduct(new \Farfetch\StructType\AssociateProduct()) !== false) {
    print_r($associate->getResult());
} else {
    print_r($associate->getLastError());
}
/**
 * Sample call for AssociateProductWithVat operation/method
 */
if ($associate->AssociateProductWithVat(new \Farfetch\StructType\AssociateProductWithVat()) !== false) {
    print_r($associate->getResult());
} else {
    print_r($associate->getLastError());
}
/**
 * Samples for Exist ServiceType
 */
$exist = new \Farfetch\ServiceType\Exist($options);
/**
 * Sample call for existSKU operation/method
 */
if ($exist->existSKU(new \Farfetch\StructType\ExistSKU()) !== false) {
    print_r($exist->getResult());
} else {
    print_r($exist->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \Farfetch\ServiceType\Is($options);
/**
 * Sample call for isBrandVisible operation/method
 */
if ($is->isBrandVisible(new \Farfetch\StructType\IsBrandVisible()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsBrandSeasonDesignerIdListBound operation/method
 */
if ($is->IsBrandSeasonDesignerIdListBound(new \Farfetch\StructType\IsBrandSeasonDesignerIdListBound()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Getnd ServiceType
 */
$getnd = new \Farfetch\ServiceType\Getnd($options);
/**
 * Sample call for Get2ndLevelCats operation/method
 */
if ($getnd->Get2ndLevelCats(new \Farfetch\StructType\Get2ndLevelCats()) !== false) {
    print_r($getnd->getResult());
} else {
    print_r($getnd->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \Farfetch\ServiceType\Search($options);
/**
 * Sample call for SearchSizeScalesForProductCreation operation/method
 */
if ($search->SearchSizeScalesForProductCreation(new \Farfetch\StructType\SearchSizeScalesForProductCreation()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \Farfetch\ServiceType\Insert($options);
/**
 * Sample call for InsertMaterials operation/method
 */
if ($insert->InsertMaterials(new \Farfetch\StructType\InsertMaterials()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertSizesQuantity operation/method
 */
if ($insert->InsertSizesQuantity(new \Farfetch\StructType\InsertSizesQuantity()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertStoreBarcode operation/method
 */
if ($insert->InsertStoreBarcode(new \Farfetch\StructType\InsertStoreBarcode()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Product ServiceType
 */
$product = new \Farfetch\ServiceType\Product($options);
/**
 * Sample call for ProductPriceUpdate operation/method
 */
if ($product->ProductPriceUpdate(new \Farfetch\StructType\ProductPriceUpdate()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \Farfetch\ServiceType\Add($options);
/**
 * Sample call for AddCountryOfOriginToItem operation/method
 */
if ($add->AddCountryOfOriginToItem(new \Farfetch\StructType\AddCountryOfOriginToItem()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDesignerIdToBrandSeasonList operation/method
 */
if ($add->AddDesignerIdToBrandSeasonList(new \Farfetch\StructType\AddDesignerIdToBrandSeasonList()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Mapp ServiceType
 */
$mapp = new \Farfetch\ServiceType\Mapp($options);
/**
 * Sample call for MappDuplicates operation/method
 */
if ($mapp->MappDuplicates(new \Farfetch\StructType\MappDuplicates()) !== false) {
    print_r($mapp->getResult());
} else {
    print_r($mapp->getLastError());
}
