<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SizeRange StructType
 * @subpackage Structs
 */
class SizeRange extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The MinimumSizePos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MinimumSizePos;
    /**
     * The MaximumSizePos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumSizePos;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ParentId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Acronym
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acronym;
    /**
     * The FriendlyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FriendlyName;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The Sizes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfItemSize
     */
    public $Sizes;
    /**
     * Constructor method for SizeRange
     * @uses SizeRange::setId()
     * @uses SizeRange::setMinimumSizePos()
     * @uses SizeRange::setMaximumSizePos()
     * @uses SizeRange::setParentId()
     * @uses SizeRange::setName()
     * @uses SizeRange::setAcronym()
     * @uses SizeRange::setFriendlyName()
     * @uses SizeRange::setCountryCode()
     * @uses SizeRange::setSizes()
     * @param int $id
     * @param int $minimumSizePos
     * @param int $maximumSizePos
     * @param int $parentId
     * @param string $name
     * @param string $acronym
     * @param string $friendlyName
     * @param string $countryCode
     * @param \Farfetch\ArrayType\ArrayOfItemSize $sizes
     */
    public function __construct($id = null, $minimumSizePos = null, $maximumSizePos = null, $parentId = null, $name = null, $acronym = null, $friendlyName = null, $countryCode = null, \Farfetch\ArrayType\ArrayOfItemSize $sizes = null)
    {
        $this
            ->setId($id)
            ->setMinimumSizePos($minimumSizePos)
            ->setMaximumSizePos($maximumSizePos)
            ->setParentId($parentId)
            ->setName($name)
            ->setAcronym($acronym)
            ->setFriendlyName($friendlyName)
            ->setCountryCode($countryCode)
            ->setSizes($sizes);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Farfetch\StructType\SizeRange
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MinimumSizePos value
     * @return int
     */
    public function getMinimumSizePos()
    {
        return $this->MinimumSizePos;
    }
    /**
     * Set MinimumSizePos value
     * @param int $minimumSizePos
     * @return \Farfetch\StructType\SizeRange
     */
    public function setMinimumSizePos($minimumSizePos = null)
    {
        // validation for constraint: int
        if (!is_null($minimumSizePos) && !(is_int($minimumSizePos) || ctype_digit($minimumSizePos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumSizePos, true), gettype($minimumSizePos)), __LINE__);
        }
        $this->MinimumSizePos = $minimumSizePos;
        return $this;
    }
    /**
     * Get MaximumSizePos value
     * @return int
     */
    public function getMaximumSizePos()
    {
        return $this->MaximumSizePos;
    }
    /**
     * Set MaximumSizePos value
     * @param int $maximumSizePos
     * @return \Farfetch\StructType\SizeRange
     */
    public function setMaximumSizePos($maximumSizePos = null)
    {
        // validation for constraint: int
        if (!is_null($maximumSizePos) && !(is_int($maximumSizePos) || ctype_digit($maximumSizePos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumSizePos, true), gettype($maximumSizePos)), __LINE__);
        }
        $this->MaximumSizePos = $maximumSizePos;
        return $this;
    }
    /**
     * Get ParentId value
     * @return int
     */
    public function getParentId()
    {
        return $this->ParentId;
    }
    /**
     * Set ParentId value
     * @param int $parentId
     * @return \Farfetch\StructType\SizeRange
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: int
        if (!is_null($parentId) && !(is_int($parentId) || ctype_digit($parentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        $this->ParentId = $parentId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Farfetch\StructType\SizeRange
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Acronym value
     * @return string|null
     */
    public function getAcronym()
    {
        return $this->Acronym;
    }
    /**
     * Set Acronym value
     * @param string $acronym
     * @return \Farfetch\StructType\SizeRange
     */
    public function setAcronym($acronym = null)
    {
        // validation for constraint: string
        if (!is_null($acronym) && !is_string($acronym)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acronym, true), gettype($acronym)), __LINE__);
        }
        $this->Acronym = $acronym;
        return $this;
    }
    /**
     * Get FriendlyName value
     * @return string|null
     */
    public function getFriendlyName()
    {
        return $this->FriendlyName;
    }
    /**
     * Set FriendlyName value
     * @param string $friendlyName
     * @return \Farfetch\StructType\SizeRange
     */
    public function setFriendlyName($friendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($friendlyName) && !is_string($friendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($friendlyName, true), gettype($friendlyName)), __LINE__);
        }
        $this->FriendlyName = $friendlyName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Farfetch\StructType\SizeRange
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Sizes value
     * @return \Farfetch\ArrayType\ArrayOfItemSize|null
     */
    public function getSizes()
    {
        return $this->Sizes;
    }
    /**
     * Set Sizes value
     * @param \Farfetch\ArrayType\ArrayOfItemSize $sizes
     * @return \Farfetch\StructType\SizeRange
     */
    public function setSizes(\Farfetch\ArrayType\ArrayOfItemSize $sizes = null)
    {
        $this->Sizes = $sizes;
        return $this;
    }
}
