<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSummary StructType
 * @subpackage Structs
 */
class ProductSummary extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The SizeRangeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SizeRangeId;
    /**
     * The BrandId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BrandId;
    /**
     * The StyleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StyleId;
    /**
     * The DesignerColorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DesignerColorId;
    /**
     * The MainColorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MainColorId;
    /**
     * The GenderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GenderId;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SeasonId;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryId;
    /**
     * The FriendlyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FriendlyName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortDescription;
    /**
     * The ProductLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductLink;
    /**
     * The SizeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\StructType\SizeRange
     */
    public $SizeRange;
    /**
     * Constructor method for ProductSummary
     * @uses ProductSummary::setItemId()
     * @uses ProductSummary::setSizeRangeId()
     * @uses ProductSummary::setBrandId()
     * @uses ProductSummary::setStyleId()
     * @uses ProductSummary::setDesignerColorId()
     * @uses ProductSummary::setMainColorId()
     * @uses ProductSummary::setGenderId()
     * @uses ProductSummary::setSeasonId()
     * @uses ProductSummary::setCategoryId()
     * @uses ProductSummary::setFriendlyName()
     * @uses ProductSummary::setName()
     * @uses ProductSummary::setShortDescription()
     * @uses ProductSummary::setProductLink()
     * @uses ProductSummary::setSizeRange()
     * @param int $itemId
     * @param int $sizeRangeId
     * @param int $brandId
     * @param int $styleId
     * @param int $designerColorId
     * @param int $mainColorId
     * @param int $genderId
     * @param int $seasonId
     * @param int $categoryId
     * @param string $friendlyName
     * @param string $name
     * @param string $shortDescription
     * @param string $productLink
     * @param \Farfetch\StructType\SizeRange $sizeRange
     */
    public function __construct($itemId = null, $sizeRangeId = null, $brandId = null, $styleId = null, $designerColorId = null, $mainColorId = null, $genderId = null, $seasonId = null, $categoryId = null, $friendlyName = null, $name = null, $shortDescription = null, $productLink = null, \Farfetch\StructType\SizeRange $sizeRange = null)
    {
        $this
            ->setItemId($itemId)
            ->setSizeRangeId($sizeRangeId)
            ->setBrandId($brandId)
            ->setStyleId($styleId)
            ->setDesignerColorId($designerColorId)
            ->setMainColorId($mainColorId)
            ->setGenderId($genderId)
            ->setSeasonId($seasonId)
            ->setCategoryId($categoryId)
            ->setFriendlyName($friendlyName)
            ->setName($name)
            ->setShortDescription($shortDescription)
            ->setProductLink($productLink)
            ->setSizeRange($sizeRange);
    }
    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get SizeRangeId value
     * @return int
     */
    public function getSizeRangeId()
    {
        return $this->SizeRangeId;
    }
    /**
     * Set SizeRangeId value
     * @param int $sizeRangeId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setSizeRangeId($sizeRangeId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeRangeId) && !(is_int($sizeRangeId) || ctype_digit($sizeRangeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeRangeId, true), gettype($sizeRangeId)), __LINE__);
        }
        $this->SizeRangeId = $sizeRangeId;
        return $this;
    }
    /**
     * Get BrandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->BrandId;
    }
    /**
     * Set BrandId value
     * @param int $brandId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->BrandId = $brandId;
        return $this;
    }
    /**
     * Get StyleId value
     * @return int
     */
    public function getStyleId()
    {
        return $this->StyleId;
    }
    /**
     * Set StyleId value
     * @param int $styleId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setStyleId($styleId = null)
    {
        // validation for constraint: int
        if (!is_null($styleId) && !(is_int($styleId) || ctype_digit($styleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($styleId, true), gettype($styleId)), __LINE__);
        }
        $this->StyleId = $styleId;
        return $this;
    }
    /**
     * Get DesignerColorId value
     * @return int
     */
    public function getDesignerColorId()
    {
        return $this->DesignerColorId;
    }
    /**
     * Set DesignerColorId value
     * @param int $designerColorId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setDesignerColorId($designerColorId = null)
    {
        // validation for constraint: int
        if (!is_null($designerColorId) && !(is_int($designerColorId) || ctype_digit($designerColorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($designerColorId, true), gettype($designerColorId)), __LINE__);
        }
        $this->DesignerColorId = $designerColorId;
        return $this;
    }
    /**
     * Get MainColorId value
     * @return int
     */
    public function getMainColorId()
    {
        return $this->MainColorId;
    }
    /**
     * Set MainColorId value
     * @param int $mainColorId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setMainColorId($mainColorId = null)
    {
        // validation for constraint: int
        if (!is_null($mainColorId) && !(is_int($mainColorId) || ctype_digit($mainColorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mainColorId, true), gettype($mainColorId)), __LINE__);
        }
        $this->MainColorId = $mainColorId;
        return $this;
    }
    /**
     * Get GenderId value
     * @return int
     */
    public function getGenderId()
    {
        return $this->GenderId;
    }
    /**
     * Set GenderId value
     * @param int $genderId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setGenderId($genderId = null)
    {
        // validation for constraint: int
        if (!is_null($genderId) && !(is_int($genderId) || ctype_digit($genderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($genderId, true), gettype($genderId)), __LINE__);
        }
        $this->GenderId = $genderId;
        return $this;
    }
    /**
     * Get SeasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->SeasonId;
    }
    /**
     * Set SeasonId value
     * @param int $seasonId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->SeasonId = $seasonId;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get FriendlyName value
     * @return string|null
     */
    public function getFriendlyName()
    {
        return $this->FriendlyName;
    }
    /**
     * Set FriendlyName value
     * @param string $friendlyName
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setFriendlyName($friendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($friendlyName) && !is_string($friendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($friendlyName, true), gettype($friendlyName)), __LINE__);
        }
        $this->FriendlyName = $friendlyName;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get ProductLink value
     * @return string|null
     */
    public function getProductLink()
    {
        return $this->ProductLink;
    }
    /**
     * Set ProductLink value
     * @param string $productLink
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setProductLink($productLink = null)
    {
        // validation for constraint: string
        if (!is_null($productLink) && !is_string($productLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productLink, true), gettype($productLink)), __LINE__);
        }
        $this->ProductLink = $productLink;
        return $this;
    }
    /**
     * Get SizeRange value
     * @return \Farfetch\StructType\SizeRange|null
     */
    public function getSizeRange()
    {
        return $this->SizeRange;
    }
    /**
     * Set SizeRange value
     * @param \Farfetch\StructType\SizeRange $sizeRange
     * @return \Farfetch\StructType\ProductSummary
     */
    public function setSizeRange(\Farfetch\StructType\SizeRange $sizeRange = null)
    {
        $this->SizeRange = $sizeRange;
        return $this;
    }
}
