<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPriceUpdate StructType
 * @subpackage Structs
 */
class ProductPriceUpdate extends AbstractStructBase
{
    /**
     * The storeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeId;
    /**
     * The articleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $articleId;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $price;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $discount;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * The sku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * Constructor method for ProductPriceUpdate
     * @uses ProductPriceUpdate::setStoreId()
     * @uses ProductPriceUpdate::setArticleId()
     * @uses ProductPriceUpdate::setPrice()
     * @uses ProductPriceUpdate::setDiscount()
     * @uses ProductPriceUpdate::setSafeKey()
     * @uses ProductPriceUpdate::setBarcode()
     * @uses ProductPriceUpdate::setSku()
     * @param int $storeId
     * @param int $articleId
     * @param float $price
     * @param float $discount
     * @param string $safeKey
     * @param string $barcode
     * @param string $sku
     */
    public function __construct($storeId = null, $articleId = null, $price = null, $discount = null, $safeKey = null, $barcode = null, $sku = null)
    {
        $this
            ->setStoreId($storeId)
            ->setArticleId($articleId)
            ->setPrice($price)
            ->setDiscount($discount)
            ->setSafeKey($safeKey)
            ->setBarcode($barcode)
            ->setSku($sku);
    }
    /**
     * Get storeId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param int $storeId
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get articleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param float $discount
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \Farfetch\StructType\ProductPriceUpdate
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
}
