<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsBrandSeasonDesignerIdListBound StructType
 * @subpackage Structs
 */
class IsBrandSeasonDesignerIdListBound extends AbstractStructBase
{
    /**
     * The brandId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandId;
    /**
     * The seasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $seasonId;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for IsBrandSeasonDesignerIdListBound
     * @uses IsBrandSeasonDesignerIdListBound::setBrandId()
     * @uses IsBrandSeasonDesignerIdListBound::setSeasonId()
     * @uses IsBrandSeasonDesignerIdListBound::setSafeKey()
     * @param int $brandId
     * @param int $seasonId
     * @param string $safeKey
     */
    public function __construct($brandId = null, $seasonId = null, $safeKey = null)
    {
        $this
            ->setBrandId($brandId)
            ->setSeasonId($seasonId)
            ->setSafeKey($safeKey);
    }
    /**
     * Get brandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->brandId;
    }
    /**
     * Set brandId value
     * @param int $brandId
     * @return \Farfetch\StructType\IsBrandSeasonDesignerIdListBound
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->brandId = $brandId;
        return $this;
    }
    /**
     * Get seasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->seasonId;
    }
    /**
     * Set seasonId value
     * @param int $seasonId
     * @return \Farfetch\StructType\IsBrandSeasonDesignerIdListBound
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->seasonId = $seasonId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\IsBrandSeasonDesignerIdListBound
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
}
