<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get2ndLevelCats StructType
 * @subpackage Structs
 */
class Get2ndLevelCats extends AbstractStructBase
{
    /**
     * The FirstLevelCat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FirstLevelCat;
    /**
     * The SafeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SafeKey;
    /**
     * Constructor method for Get2ndLevelCats
     * @uses Get2ndLevelCats::setFirstLevelCat()
     * @uses Get2ndLevelCats::setSafeKey()
     * @param int $firstLevelCat
     * @param string $safeKey
     */
    public function __construct($firstLevelCat = null, $safeKey = null)
    {
        $this
            ->setFirstLevelCat($firstLevelCat)
            ->setSafeKey($safeKey);
    }
    /**
     * Get FirstLevelCat value
     * @return int
     */
    public function getFirstLevelCat()
    {
        return $this->FirstLevelCat;
    }
    /**
     * Set FirstLevelCat value
     * @param int $firstLevelCat
     * @return \Farfetch\StructType\Get2ndLevelCats
     */
    public function setFirstLevelCat($firstLevelCat = null)
    {
        // validation for constraint: int
        if (!is_null($firstLevelCat) && !(is_int($firstLevelCat) || ctype_digit($firstLevelCat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstLevelCat, true), gettype($firstLevelCat)), __LINE__);
        }
        $this->FirstLevelCat = $firstLevelCat;
        return $this;
    }
    /**
     * Get SafeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->SafeKey;
    }
    /**
     * Set SafeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\Get2ndLevelCats
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->SafeKey = $safeKey;
        return $this;
    }
}
