<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociationResult StructType
 * @subpackage Structs
 */
class AssociationResult extends AbstractStructBase
{
    /**
     * The SizeScaleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SizeScaleId;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemId;
    /**
     * The SizeScaleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SizeScaleName;
    /**
     * The ErrorMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfString
     */
    public $ErrorMessages;
    /**
     * The Barcodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfBoutiqueBarcodeResult
     */
    public $Barcodes;
    /**
     * Constructor method for AssociationResult
     * @uses AssociationResult::setSizeScaleId()
     * @uses AssociationResult::setSuccess()
     * @uses AssociationResult::setItemId()
     * @uses AssociationResult::setSizeScaleName()
     * @uses AssociationResult::setErrorMessages()
     * @uses AssociationResult::setBarcodes()
     * @param int $sizeScaleId
     * @param bool $success
     * @param string $itemId
     * @param string $sizeScaleName
     * @param \Farfetch\ArrayType\ArrayOfString $errorMessages
     * @param \Farfetch\ArrayType\ArrayOfBoutiqueBarcodeResult $barcodes
     */
    public function __construct($sizeScaleId = null, $success = null, $itemId = null, $sizeScaleName = null, \Farfetch\ArrayType\ArrayOfString $errorMessages = null, \Farfetch\ArrayType\ArrayOfBoutiqueBarcodeResult $barcodes = null)
    {
        $this
            ->setSizeScaleId($sizeScaleId)
            ->setSuccess($success)
            ->setItemId($itemId)
            ->setSizeScaleName($sizeScaleName)
            ->setErrorMessages($errorMessages)
            ->setBarcodes($barcodes);
    }
    /**
     * Get SizeScaleId value
     * @return int
     */
    public function getSizeScaleId()
    {
        return $this->SizeScaleId;
    }
    /**
     * Set SizeScaleId value
     * @param int $sizeScaleId
     * @return \Farfetch\StructType\AssociationResult
     */
    public function setSizeScaleId($sizeScaleId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeScaleId) && !(is_int($sizeScaleId) || ctype_digit($sizeScaleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeScaleId, true), gettype($sizeScaleId)), __LINE__);
        }
        $this->SizeScaleId = $sizeScaleId;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \Farfetch\StructType\AssociationResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \Farfetch\StructType\AssociationResult
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get SizeScaleName value
     * @return string|null
     */
    public function getSizeScaleName()
    {
        return $this->SizeScaleName;
    }
    /**
     * Set SizeScaleName value
     * @param string $sizeScaleName
     * @return \Farfetch\StructType\AssociationResult
     */
    public function setSizeScaleName($sizeScaleName = null)
    {
        // validation for constraint: string
        if (!is_null($sizeScaleName) && !is_string($sizeScaleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeScaleName, true), gettype($sizeScaleName)), __LINE__);
        }
        $this->SizeScaleName = $sizeScaleName;
        return $this;
    }
    /**
     * Get ErrorMessages value
     * @return \Farfetch\ArrayType\ArrayOfString|null
     */
    public function getErrorMessages()
    {
        return $this->ErrorMessages;
    }
    /**
     * Set ErrorMessages value
     * @param \Farfetch\ArrayType\ArrayOfString $errorMessages
     * @return \Farfetch\StructType\AssociationResult
     */
    public function setErrorMessages(\Farfetch\ArrayType\ArrayOfString $errorMessages = null)
    {
        $this->ErrorMessages = $errorMessages;
        return $this;
    }
    /**
     * Get Barcodes value
     * @return \Farfetch\ArrayType\ArrayOfBoutiqueBarcodeResult|null
     */
    public function getBarcodes()
    {
        return $this->Barcodes;
    }
    /**
     * Set Barcodes value
     * @param \Farfetch\ArrayType\ArrayOfBoutiqueBarcodeResult $barcodes
     * @return \Farfetch\StructType\AssociationResult
     */
    public function setBarcodes(\Farfetch\ArrayType\ArrayOfBoutiqueBarcodeResult $barcodes = null)
    {
        $this->Barcodes = $barcodes;
        return $this;
    }
}
