<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetPossibleDuplicates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetPossibleDuplicates $parameters
     * @return \Farfetch\StructType\GetPossibleDuplicatesResponse|bool
     */
    public function GetPossibleDuplicates(\Farfetch\StructType\GetPossibleDuplicates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPossibleDuplicates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBrandRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetBrandRegions $parameters
     * @return \Farfetch\StructType\GetBrandRegionsResponse|bool
     */
    public function GetBrandRegions(\Farfetch\StructType\GetBrandRegions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBrandRegions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetAllStock $parameters
     * @return \Farfetch\StructType\GetAllStockResponse|bool
     */
    public function GetAllStock(\Farfetch\StructType\GetAllStock $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStockWithStoreBarcodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetAllStockWithStoreBarcodes $parameters
     * @return \Farfetch\StructType\GetAllStockWithStoreBarcodesResponse|bool
     */
    public function GetAllStockWithStoreBarcodes(\Farfetch\StructType\GetAllStockWithStoreBarcodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllStockWithStoreBarcodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBoxName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetBoxName $parameters
     * @return \Farfetch\StructType\GetBoxNameResponse|bool
     */
    public function GetBoxName(\Farfetch\StructType\GetBoxName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBoxName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBoxes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetBoxes $parameters
     * @return \Farfetch\StructType\GetBoxesResponse|bool
     */
    public function GetBoxes(\Farfetch\StructType\GetBoxes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBoxes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDefaultCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetDefaultCountries $parameters
     * @return \Farfetch\StructType\GetDefaultCountriesResponse|bool
     */
    public function GetDefaultCountries(\Farfetch\StructType\GetDefaultCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDefaultCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetList $parameters
     * @return \Farfetch\StructType\GetListResponse|bool
     */
    public function GetList(\Farfetch\StructType\GetList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetColourTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetColourTypes $parameters
     * @return \Farfetch\StructType\GetColourTypesResponse|bool
     */
    public function GetColourTypes(\Farfetch\StructType\GetColourTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetColourTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetComposition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetComposition $parameters
     * @return \Farfetch\StructType\GetCompositionResponse|bool
     */
    public function GetComposition(\Farfetch\StructType\GetComposition $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetComposition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMainView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetMainView $parameters
     * @return \Farfetch\StructType\GetMainViewResponse|bool
     */
    public function GetMainView(\Farfetch\StructType\GetMainView $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMainView($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMeasures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetMeasures $parameters
     * @return \Farfetch\StructType\GetMeasuresResponse|bool
     */
    public function GetMeasures(\Farfetch\StructType\GetMeasures $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMeasures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPropValueNameById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetPropValueNameById $parameters
     * @return \Farfetch\StructType\GetPropValueNameByIdResponse|bool
     */
    public function GetPropValueNameById(\Farfetch\StructType\GetPropValueNameById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPropValueNameById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPropValueIdByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetPropValueIdByName $parameters
     * @return \Farfetch\StructType\GetPropValueIdByNameResponse|bool
     */
    public function GetPropValueIdByName(\Farfetch\StructType\GetPropValueIdByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPropValueIdByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetProperty $parameters
     * @return \Farfetch\StructType\GetPropertyResponse|bool
     */
    public function GetProperty(\Farfetch\StructType\GetProperty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizeHelpId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSizeHelpId $parameters
     * @return \Farfetch\StructType\GetSizeHelpIdResponse|bool
     */
    public function GetSizeHelpId(\Farfetch\StructType\GetSizeHelpId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSizeHelpId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSizes $parameters
     * @return \Farfetch\StructType\GetSizesResponse|bool
     */
    public function GetSizes(\Farfetch\StructType\GetSizes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSizes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetStock $parameters
     * @return \Farfetch\StructType\GetStockResponse|bool
     */
    public function GetStock(\Farfetch\StructType\GetStock $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetStoreItems $parameters
     * @return \Farfetch\StructType\GetStoreItemsResponse|bool
     */
    public function GetStoreItems(\Farfetch\StructType\GetStoreItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStoreItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStorePrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetStorePrice $parameters
     * @return \Farfetch\StructType\GetStorePriceResponse|bool
     */
    public function GetStorePrice(\Farfetch\StructType\GetStorePrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStorePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebsiteDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetWebsiteDescription $parameters
     * @return \Farfetch\StructType\GetWebsiteDescriptionResponse|bool
     */
    public function GetWebsiteDescription(\Farfetch\StructType\GetWebsiteDescription $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebsiteDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSKUandDesingerID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSKUandDesingerID $parameters
     * @return \Farfetch\StructType\GetSKUandDesingerIDResponse|bool
     */
    public function GetSKUandDesingerID(\Farfetch\StructType\GetSKUandDesingerID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSKUandDesingerID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParentItemId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetParentItemId $parameters
     * @return \Farfetch\StructType\GetParentItemIdResponse|bool
     */
    public function GetParentItemId(\Farfetch\StructType\GetParentItemId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetParentItemId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFFItemId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetFFItemId $parameters
     * @return \Farfetch\StructType\GetFFItemIdResponse|bool
     */
    public function GetFFItemId(\Farfetch\StructType\GetFFItemId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFFItemId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFFItemUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetFFItemUrl $parameters
     * @return \Farfetch\StructType\GetFFItemUrlResponse|bool
     */
    public function GetFFItemUrl(\Farfetch\StructType\GetFFItemUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFFItemUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGender
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetGender $parameters
     * @return \Farfetch\StructType\GetGenderResponse|bool
     */
    public function GetGender(\Farfetch\StructType\GetGender $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGender($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMaterialCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetMaterialCategory $parameters
     * @return \Farfetch\StructType\GetMaterialCategoryResponse|bool
     */
    public function GetMaterialCategory(\Farfetch\StructType\GetMaterialCategory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMaterialCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetMaterial $parameters
     * @return \Farfetch\StructType\GetMaterialResponse|bool
     */
    public function GetMaterial(\Farfetch\StructType\GetMaterial $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMaterial($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetCategories $parameters
     * @return \Farfetch\StructType\GetCategoriesResponse|bool
     */
    public function GetCategories(\Farfetch\StructType\GetCategories $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizeRangesFiltered
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSizeRangesFiltered $parameters
     * @return \Farfetch\StructType\GetSizeRangesFilteredResponse|bool
     */
    public function GetSizeRangesFiltered(\Farfetch\StructType\GetSizeRangesFiltered $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSizeRangesFiltered($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSlots
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSlots $parameters
     * @return \Farfetch\StructType\GetSlotsResponse|bool
     */
    public function GetSlots(\Farfetch\StructType\GetSlots $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSlots($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpenSlots
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetOpenSlots $parameters
     * @return \Farfetch\StructType\GetOpenSlotsResponse|bool
     */
    public function GetOpenSlots(\Farfetch\StructType\GetOpenSlots $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOpenSlots($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSonId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSonId $parameters
     * @return \Farfetch\StructType\GetSonIdResponse|bool
     */
    public function GetSonId(\Farfetch\StructType\GetSonId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSonId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSonIdForOrderManagement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetSonIdForOrderManagement $parameters
     * @return \Farfetch\StructType\GetSonIdForOrderManagementResponse|bool
     */
    public function GetSonIdForOrderManagement(\Farfetch\StructType\GetSonIdForOrderManagement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSonIdForOrderManagement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDesignerIdsForSeasonBrand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetDesignerIdsForSeasonBrand $parameters
     * @return \Farfetch\StructType\GetDesignerIdsForSeasonBrandResponse|bool
     */
    public function GetDesignerIdsForSeasonBrand(\Farfetch\StructType\GetDesignerIdsForSeasonBrand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDesignerIdsForSeasonBrand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPictures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetAllPictures $parameters
     * @return \Farfetch\StructType\GetAllPicturesResponse|bool
     */
    public function GetAllPictures(\Farfetch\StructType\GetAllPictures $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllPictures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPicturesByBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetAllPicturesByBarcode $parameters
     * @return \Farfetch\StructType\GetAllPicturesByBarcodeResponse|bool
     */
    public function GetAllPicturesByBarcode(\Farfetch\StructType\GetAllPicturesByBarcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllPicturesByBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSizeRangesInUse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetAllSizeRangesInUse $parameters
     * @return \Farfetch\StructType\GetAllSizeRangesInUseResponse|bool
     */
    public function GetAllSizeRangesInUse(\Farfetch\StructType\GetAllSizeRangesInUse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllSizeRangesInUse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransportationProperties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetTransportationProperties $parameters
     * @return \Farfetch\StructType\GetTransportationPropertiesResponse|bool
     */
    public function GetTransportationProperties(\Farfetch\StructType\GetTransportationProperties $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransportationProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductTransportationProperties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\GetProductTransportationProperties $parameters
     * @return \Farfetch\StructType\GetProductTransportationPropertiesResponse|bool
     */
    public function GetProductTransportationProperties(\Farfetch\StructType\GetProductTransportationProperties $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductTransportationProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\GetAllPicturesByBarcodeResponse|\Farfetch\StructType\GetAllPicturesResponse|\Farfetch\StructType\GetAllSizeRangesInUseResponse|\Farfetch\StructType\GetAllStockResponse|\Farfetch\StructType\GetAllStockWithStoreBarcodesResponse|\Farfetch\StructType\GetBoxesResponse|\Farfetch\StructType\GetBoxNameResponse|\Farfetch\StructType\GetBrandRegionsResponse|\Farfetch\StructType\GetCategoriesResponse|\Farfetch\StructType\GetColourTypesResponse|\Farfetch\StructType\GetCompositionResponse|\Farfetch\StructType\GetDefaultCountriesResponse|\Farfetch\StructType\GetDesignerIdsForSeasonBrandResponse|\Farfetch\StructType\GetFFItemIdResponse|\Farfetch\StructType\GetFFItemUrlResponse|\Farfetch\StructType\GetGenderResponse|\Farfetch\StructType\GetListResponse|\Farfetch\StructType\GetMainViewResponse|\Farfetch\StructType\GetMaterialCategoryResponse|\Farfetch\StructType\GetMaterialResponse|\Farfetch\StructType\GetMeasuresResponse|\Farfetch\StructType\GetOpenSlotsResponse|\Farfetch\StructType\GetParentItemIdResponse|\Farfetch\StructType\GetPossibleDuplicatesResponse|\Farfetch\StructType\GetProductTransportationPropertiesResponse|\Farfetch\StructType\GetPropertyResponse|\Farfetch\StructType\GetPropValueIdByNameResponse|\Farfetch\StructType\GetPropValueNameByIdResponse|\Farfetch\StructType\GetSizeHelpIdResponse|\Farfetch\StructType\GetSizeRangesFilteredResponse|\Farfetch\StructType\GetSizesResponse|\Farfetch\StructType\GetSKUandDesingerIDResponse|\Farfetch\StructType\GetSlotsResponse|\Farfetch\StructType\GetSonIdForOrderManagementResponse|\Farfetch\StructType\GetSonIdResponse|\Farfetch\StructType\GetStockResponse|\Farfetch\StructType\GetStoreItemsResponse|\Farfetch\StructType\GetStorePriceResponse|\Farfetch\StructType\GetTransportationPropertiesResponse|\Farfetch\StructType\GetWebsiteDescriptionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
