<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Exist ServiceType
 * @subpackage Services
 */
class Exist extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named existSKU
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\ExistSKU $parameters
     * @return \Farfetch\StructType\ExistSKUResponse|bool
     */
    public function existSKU(\Farfetch\StructType\ExistSKU $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->existSKU($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\ExistSKUResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
