<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KargoBarkod StructType
 * @subpackage Structs
 */
class KargoBarkod extends AbstractStructBase
{
    /**
     * The OzelKargoTakipNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OzelKargoTakipNo;
    /**
     * The Aciklama
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Detay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKargoBarkodDetay
     */
    public $Detay;
    /**
     * The PdfBarkod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PdfBarkod;
    /**
     * The PpdBarkod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PpdBarkod;
    /**
     * Constructor method for KargoBarkod
     * @uses KargoBarkod::setOzelKargoTakipNo()
     * @uses KargoBarkod::setAciklama()
     * @uses KargoBarkod::setDetay()
     * @uses KargoBarkod::setPdfBarkod()
     * @uses KargoBarkod::setPpdBarkod()
     * @param string $ozelKargoTakipNo
     * @param string $aciklama
     * @param \ArrayType\ArrayOfKargoBarkodDetay $detay
     * @param string $pdfBarkod
     * @param \ArrayType\ArrayOfString $ppdBarkod
     */
    public function __construct($ozelKargoTakipNo = null, $aciklama = null, \ArrayType\ArrayOfKargoBarkodDetay $detay = null, $pdfBarkod = null, \ArrayType\ArrayOfString $ppdBarkod = null)
    {
        $this
            ->setOzelKargoTakipNo($ozelKargoTakipNo)
            ->setAciklama($aciklama)
            ->setDetay($detay)
            ->setPdfBarkod($pdfBarkod)
            ->setPpdBarkod($ppdBarkod);
    }
    /**
     * Get OzelKargoTakipNo value
     * @return string|null
     */
    public function getOzelKargoTakipNo()
    {
        return $this->OzelKargoTakipNo;
    }
    /**
     * Set OzelKargoTakipNo value
     * @param string $ozelKargoTakipNo
     * @return \StructType\KargoBarkod
     */
    public function setOzelKargoTakipNo($ozelKargoTakipNo = null)
    {
        // validation for constraint: string
        if (!is_null($ozelKargoTakipNo) && !is_string($ozelKargoTakipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ozelKargoTakipNo, true), gettype($ozelKargoTakipNo)), __LINE__);
        }
        $this->OzelKargoTakipNo = $ozelKargoTakipNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KargoBarkod
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Detay value
     * @return \ArrayType\ArrayOfKargoBarkodDetay|null
     */
    public function getDetay()
    {
        return $this->Detay;
    }
    /**
     * Set Detay value
     * @param \ArrayType\ArrayOfKargoBarkodDetay $detay
     * @return \StructType\KargoBarkod
     */
    public function setDetay(\ArrayType\ArrayOfKargoBarkodDetay $detay = null)
    {
        $this->Detay = $detay;
        return $this;
    }
    /**
     * Get PdfBarkod value
     * @return string|null
     */
    public function getPdfBarkod()
    {
        return $this->PdfBarkod;
    }
    /**
     * Set PdfBarkod value
     * @param string $pdfBarkod
     * @return \StructType\KargoBarkod
     */
    public function setPdfBarkod($pdfBarkod = null)
    {
        // validation for constraint: string
        if (!is_null($pdfBarkod) && !is_string($pdfBarkod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfBarkod, true), gettype($pdfBarkod)), __LINE__);
        }
        $this->PdfBarkod = $pdfBarkod;
        return $this;
    }
    /**
     * Get PpdBarkod value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPpdBarkod()
    {
        return $this->PpdBarkod;
    }
    /**
     * Set PpdBarkod value
     * @param \ArrayType\ArrayOfString $ppdBarkod
     * @return \StructType\KargoBarkod
     */
    public function setPpdBarkod(\ArrayType\ArrayOfString $ppdBarkod = null)
    {
        $this->PpdBarkod = $ppdBarkod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KargoBarkod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
