<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarkodToplu StructType
 * @subpackage Structs
 */
class BarkodToplu extends AbstractStructBase
{
    /**
     * The GonderenCariKodlari
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $GonderenCariKodlari;
    /**
     * The Barkodlar
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Barkodlar;
    /**
     * The Sifre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sifre;
    /**
     * Constructor method for BarkodToplu
     * @uses BarkodToplu::setGonderenCariKodlari()
     * @uses BarkodToplu::setBarkodlar()
     * @uses BarkodToplu::setSifre()
     * @param \ArrayType\ArrayOfString $gonderenCariKodlari
     * @param \ArrayType\ArrayOfString $barkodlar
     * @param string $sifre
     */
    public function __construct(\ArrayType\ArrayOfString $gonderenCariKodlari = null, \ArrayType\ArrayOfString $barkodlar = null, $sifre = null)
    {
        $this
            ->setGonderenCariKodlari($gonderenCariKodlari)
            ->setBarkodlar($barkodlar)
            ->setSifre($sifre);
    }
    /**
     * Get GonderenCariKodlari value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getGonderenCariKodlari()
    {
        return $this->GonderenCariKodlari;
    }
    /**
     * Set GonderenCariKodlari value
     * @param \ArrayType\ArrayOfString $gonderenCariKodlari
     * @return \StructType\BarkodToplu
     */
    public function setGonderenCariKodlari(\ArrayType\ArrayOfString $gonderenCariKodlari = null)
    {
        $this->GonderenCariKodlari = $gonderenCariKodlari;
        return $this;
    }
    /**
     * Get Barkodlar value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getBarkodlar()
    {
        return $this->Barkodlar;
    }
    /**
     * Set Barkodlar value
     * @param \ArrayType\ArrayOfString $barkodlar
     * @return \StructType\BarkodToplu
     */
    public function setBarkodlar(\ArrayType\ArrayOfString $barkodlar = null)
    {
        $this->Barkodlar = $barkodlar;
        return $this;
    }
    /**
     * Get Sifre value
     * @return string|null
     */
    public function getSifre()
    {
        return $this->Sifre;
    }
    /**
     * Set Sifre value
     * @param string $sifre
     * @return \StructType\BarkodToplu
     */
    public function setSifre($sifre = null)
    {
        // validation for constraint: string
        if (!is_null($sifre) && !is_string($sifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifre, true), gettype($sifre)), __LINE__);
        }
        $this->Sifre = $sifre;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BarkodToplu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
