<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Web ServiceType
 * @subpackage Services
 */
class Web extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WebSiparisKoduAlicidan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKoduAlicidan $parameters
     * @return \StructType\WebSiparisKoduAlicidanResponse|bool
     */
    public function WebSiparisKoduAlicidan(\StructType\WebSiparisKoduAlicidan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKoduAlicidan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebSiparisKoduBorcludan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKoduBorcludan $parameters
     * @return \StructType\WebSiparisKoduBorcludanResponse|bool
     */
    public function WebSiparisKoduBorcludan(\StructType\WebSiparisKoduBorcludan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKoduBorcludan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebSiparisKodu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKodu $parameters
     * @return \StructType\WebSiparisKoduResponse|bool
     */
    public function WebSiparisKodu(\StructType\WebSiparisKodu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKodu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebSiparisKoduTopluAlicidan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKoduTopluAlicidan $parameters
     * @return \StructType\WebSiparisKoduTopluAlicidanResponse|bool
     */
    public function WebSiparisKoduTopluAlicidan(\StructType\WebSiparisKoduTopluAlicidan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKoduTopluAlicidan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebSiparisKoduTopluBorcludan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKoduTopluBorcludan $parameters
     * @return \StructType\WebSiparisKoduTopluBorcludanResponse|bool
     */
    public function WebSiparisKoduTopluBorcludan(\StructType\WebSiparisKoduTopluBorcludan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKoduTopluBorcludan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebSiparisKoduToplu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKoduToplu $parameters
     * @return \StructType\WebSiparisKoduTopluResponse|bool
     */
    public function WebSiparisKoduToplu(\StructType\WebSiparisKoduToplu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKoduToplu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WebSiparisKodundanKargoTeslimatBilgisi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSiparisKodundanKargoTeslimatBilgisi $parameters
     * @return \StructType\WebSiparisKodundanKargoTeslimatBilgisiResponse|bool
     */
    public function WebSiparisKodundanKargoTeslimatBilgisi(\StructType\WebSiparisKodundanKargoTeslimatBilgisi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WebSiparisKodundanKargoTeslimatBilgisi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WebSiparisKoduAlicidanResponse|\StructType\WebSiparisKoduBorcludanResponse|\StructType\WebSiparisKodundanKargoTeslimatBilgisiResponse|\StructType\WebSiparisKoduResponse|\StructType\WebSiparisKoduTopluAlicidanResponse|\StructType\WebSiparisKoduTopluBorcludanResponse|\StructType\WebSiparisKoduTopluResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
