<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kargom ServiceType
 * @subpackage Services
 */
class Kargom extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KargomNeredeDetay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargomNeredeDetay $parameters
     * @return \StructType\KargomNeredeDetayResponse|bool
     */
    public function KargomNeredeDetay(\StructType\KargomNeredeDetay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargomNeredeDetay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KargomNeredeDetayResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
