<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kargo ServiceType
 * @subpackage Services
 */
class Kargo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KargoBarkoduGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargoBarkoduGuncelle $parameters
     * @return \StructType\KargoBarkoduGuncelleResponse|bool
     */
    public function KargoBarkoduGuncelle(\StructType\KargoBarkoduGuncelle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargoBarkoduGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named KargoBarkodu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargoBarkodu $parameters
     * @return \StructType\KargoBarkoduResponse|bool
     */
    public function KargoBarkodu(\StructType\KargoBarkodu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargoBarkodu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KargoBarkoduGuncelleResponse|\StructType\KargoBarkoduResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
