<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Takip ServiceType
 * @subpackage Services
 */
class Takip extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TakipNo $parameters
     * @return \StructType\TakipNoResponse|bool
     */
    public function TakipNo(\StructType\TakipNo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TakipNoToplu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TakipNoToplu $parameters
     * @return \StructType\TakipNoTopluResponse|bool
     */
    public function TakipNoToplu(\StructType\TakipNoToplu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TakipNoToplu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TakipNodanKargoTeslimatBilgisi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TakipNodanKargoTeslimatBilgisi $parameters
     * @return \StructType\TakipNodanKargoTeslimatBilgisiResponse|bool
     */
    public function TakipNodanKargoTeslimatBilgisi(\StructType\TakipNodanKargoTeslimatBilgisi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TakipNodanKargoTeslimatBilgisi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TakipNodanKargoTeslimatBilgisiResponse|\StructType\TakipNoResponse|\StructType\TakipNoTopluResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
