<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cari ServiceType
 * @subpackage Services
 */
class Cari extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CariKoduveSifre
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CariKoduveSifre $parameters
     * @return \StructType\CariKoduveSifreResponse|bool
     */
    public function CariKoduveSifre(\StructType\CariKoduveSifre $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CariKoduveSifre($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CariKoduveSifreResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
