<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdemeIslemleri StructType
 * @subpackage Structs
 */
class OdemeIslemleri extends AbstractStructBase
{
    /**
     * The OdemeEvrakNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OdemeEvrakNo;
    /**
     * The Aciklama
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Detay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOdemeIslemleriDetay
     */
    public $Detay;
    /**
     * Constructor method for OdemeIslemleri
     * @uses OdemeIslemleri::setOdemeEvrakNo()
     * @uses OdemeIslemleri::setAciklama()
     * @uses OdemeIslemleri::setDetay()
     * @param string $odemeEvrakNo
     * @param string $aciklama
     * @param \ArrayType\ArrayOfOdemeIslemleriDetay $detay
     */
    public function __construct($odemeEvrakNo = null, $aciklama = null, \ArrayType\ArrayOfOdemeIslemleriDetay $detay = null)
    {
        $this
            ->setOdemeEvrakNo($odemeEvrakNo)
            ->setAciklama($aciklama)
            ->setDetay($detay);
    }
    /**
     * Get OdemeEvrakNo value
     * @return string|null
     */
    public function getOdemeEvrakNo()
    {
        return $this->OdemeEvrakNo;
    }
    /**
     * Set OdemeEvrakNo value
     * @param string $odemeEvrakNo
     * @return \StructType\OdemeIslemleri
     */
    public function setOdemeEvrakNo($odemeEvrakNo = null)
    {
        // validation for constraint: string
        if (!is_null($odemeEvrakNo) && !is_string($odemeEvrakNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odemeEvrakNo, true), gettype($odemeEvrakNo)), __LINE__);
        }
        $this->OdemeEvrakNo = $odemeEvrakNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\OdemeIslemleri
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Detay value
     * @return \ArrayType\ArrayOfOdemeIslemleriDetay|null
     */
    public function getDetay()
    {
        return $this->Detay;
    }
    /**
     * Set Detay value
     * @param \ArrayType\ArrayOfOdemeIslemleriDetay $detay
     * @return \StructType\OdemeIslemleri
     */
    public function setDetay(\ArrayType\ArrayOfOdemeIslemleriDetay $detay = null)
    {
        $this->Detay = $detay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OdemeIslemleri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
