<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kapidan ServiceType
 * @subpackage Services
 */
class Kapidan extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KapidanTakip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KapidanTakip $parameters
     * @return \StructType\KapidanTakipResponse|bool
     */
    public function KapidanTakip(\StructType\KapidanTakip $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KapidanTakip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named KapidanOdemeliKargolar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KapidanOdemeliKargolar $parameters
     * @return \StructType\KapidanOdemeliKargolarResponse|bool
     */
    public function KapidanOdemeliKargolar(\StructType\KapidanOdemeliKargolar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KapidanOdemeliKargolar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KapidanOdemeliKargolarResponse|\StructType\KapidanTakipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
