<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Iade ServiceType
 * @subpackage Services
 */
class Iade extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IadeKargolar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IadeKargolar $parameters
     * @return \StructType\IadeKargolarResponse|bool
     */
    public function IadeKargolar(\StructType\IadeKargolar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IadeKargolar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IadeKargolarProva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IadeKargolarProva $parameters
     * @return \StructType\IadeKargolarProvaResponse|bool
     */
    public function IadeKargolarProva(\StructType\IadeKargolarProva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IadeKargolarProva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IadeKargolarToplu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IadeKargolarToplu $parameters
     * @return \StructType\IadeKargolarTopluResponse|bool
     */
    public function IadeKargolarToplu(\StructType\IadeKargolarToplu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IadeKargolarToplu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IadeKargolarTopluAlim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IadeKargolarTopluAlim $parameters
     * @return \StructType\IadeKargolarTopluAlimResponse|bool
     */
    public function IadeKargolarTopluAlim(\StructType\IadeKargolarTopluAlim $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IadeKargolarTopluAlim($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IadeKargolarProvaResponse|\StructType\IadeKargolarResponse|\StructType\IadeKargolarTopluAlimResponse|\StructType\IadeKargolarTopluResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
