<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Barkod ServiceType
 * @subpackage Services
 */
class Barkod extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Barkod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Barkod $parameters
     * @return \StructType\BarkodResponse|bool
     */
    public function Barkod(\StructType\Barkod $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Barkod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BarkodToplu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BarkodToplu $parameters
     * @return \StructType\BarkodTopluResponse|bool
     */
    public function BarkodToplu(\StructType\BarkodToplu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BarkodToplu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BarkodResponse|\StructType\BarkodTopluResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
