<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pazaryeri ServiceType
 * @subpackage Services
 */
class Pazaryeri extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PazaryeriGonderiHareketDetayli
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PazaryeriGonderiHareketDetayli $parameters
     * @return \StructType\PazaryeriGonderiHareketDetayliResponse|bool
     */
    public function PazaryeriGonderiHareketDetayli(\StructType\PazaryeriGonderiHareketDetayli $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PazaryeriGonderiHareketDetayli($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PazaryeriGonderiHareketDetayliResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
