<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Musteri ServiceType
 * @subpackage Services
 */
class Musteri extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MusteriBilgisi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriBilgisi $parameters
     * @return \StructType\MusteriBilgisiResponse|bool
     */
    public function MusteriBilgisi(\StructType\MusteriBilgisi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriBilgisi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriBilgisiYeni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriBilgisiYeni $parameters
     * @return \StructType\MusteriBilgisiYeniResponse|bool
     */
    public function MusteriBilgisiYeni(\StructType\MusteriBilgisiYeni $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriBilgisiYeni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriBilgisiProva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriBilgisiProva $parameters
     * @return \StructType\MusteriBilgisiProvaResponse|bool
     */
    public function MusteriBilgisiProva(\StructType\MusteriBilgisiProva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriBilgisiProva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MusteriBilgisiProvaResponse|\StructType\MusteriBilgisiResponse|\StructType\MusteriBilgisiYeniResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
