<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ivr ServiceType
 * @subpackage Services
 */
class Ivr extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IvrKargomNerede
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IvrKargomNerede $parameters
     * @return \StructType\IvrKargomNeredeResponse|bool
     */
    public function IvrKargomNerede(\StructType\IvrKargomNerede $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IvrKargomNerede($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IvrKargomNeredeTelNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IvrKargomNeredeTelNo $parameters
     * @return \StructType\IvrKargomNeredeTelNoResponse|bool
     */
    public function IvrKargomNeredeTelNo(\StructType\IvrKargomNeredeTelNo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IvrKargomNeredeTelNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IvrKargomNeredeResponse|\StructType\IvrKargomNeredeTelNoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
