<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gruplu ServiceType
 * @subpackage Services
 */
class Gruplu extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GrupluTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrupluTakipNo $parameters
     * @return \StructType\GrupluTakipNoResponse|bool
     */
    public function GrupluTakipNo(\StructType\GrupluTakipNo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrupluTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GrupluTakipNoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
