<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gonderi ServiceType
 * @subpackage Services
 */
class Gonderi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GonderiWebServiceYurtDisi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiWebServiceYurtDisi $parameters
     * @return \StructType\GonderiWebServiceYurtDisiResponse|bool
     */
    public function GonderiWebServiceYurtDisi(\StructType\GonderiWebServiceYurtDisi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiWebServiceYurtDisi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GonderiWebServiceYurDisiTakip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiWebServiceYurDisiTakip $parameters
     * @return \StructType\GonderiWebServiceYurDisiTakipResponse|bool
     */
    public function GonderiWebServiceYurDisiTakip(\StructType\GonderiWebServiceYurDisiTakip $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiWebServiceYurDisiTakip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GonderiWebServiceYurDisiTakipDetayli
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiWebServiceYurDisiTakipDetayli $parameters
     * @return \StructType\GonderiWebServiceYurDisiTakipDetayliResponse|bool
     */
    public function GonderiWebServiceYurDisiTakipDetayli(\StructType\GonderiWebServiceYurDisiTakipDetayli $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiWebServiceYurDisiTakipDetayli($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GonderiSil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiSil $parameters
     * @return \StructType\GonderiSilResponse|bool
     */
    public function GonderiSil(\StructType\GonderiSil $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiSil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GonderiSilResponse|\StructType\GonderiWebServiceYurDisiTakipDetayliResponse|\StructType\GonderiWebServiceYurDisiTakipResponse|\StructType\GonderiWebServiceYurtDisiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
