<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantType StructType
 * @subpackage Structs
 */
class VariantType extends AbstractStructBase
{
    /**
     * The variantSpecs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VariantSpecs
     */
    public $variantSpecs;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The stockCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stockCode;
    /**
     * The soldCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $soldCount;
    /**
     * The newCatalogId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $newCatalogId;
    /**
     * The variantId
     * @var int
     */
    public $variantId;
    /**
     * The operation
     * @var string
     */
    public $operation;
    /**
     * Constructor method for variantType
     * @uses VariantType::setVariantSpecs()
     * @uses VariantType::setQuantity()
     * @uses VariantType::setStockCode()
     * @uses VariantType::setSoldCount()
     * @uses VariantType::setNewCatalogId()
     * @uses VariantType::setVariantId()
     * @uses VariantType::setOperation()
     * @param \StructType\VariantSpecs $variantSpecs
     * @param int $quantity
     * @param string $stockCode
     * @param int $soldCount
     * @param int $newCatalogId
     * @param int $variantId
     * @param string $operation
     */
    public function __construct(\StructType\VariantSpecs $variantSpecs = null, $quantity = null, $stockCode = null, $soldCount = null, $newCatalogId = null, $variantId = null, $operation = null)
    {
        $this
            ->setVariantSpecs($variantSpecs)
            ->setQuantity($quantity)
            ->setStockCode($stockCode)
            ->setSoldCount($soldCount)
            ->setNewCatalogId($newCatalogId)
            ->setVariantId($variantId)
            ->setOperation($operation);
    }
    /**
     * Get variantSpecs value
     * @return \StructType\VariantSpecs|null
     */
    public function getVariantSpecs()
    {
        return $this->variantSpecs;
    }
    /**
     * Set variantSpecs value
     * @param \StructType\VariantSpecs $variantSpecs
     * @return \StructType\VariantType
     */
    public function setVariantSpecs(\StructType\VariantSpecs $variantSpecs = null)
    {
        $this->variantSpecs = $variantSpecs;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\VariantType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get stockCode value
     * @return string|null
     */
    public function getStockCode()
    {
        return $this->stockCode;
    }
    /**
     * Set stockCode value
     * @param string $stockCode
     * @return \StructType\VariantType
     */
    public function setStockCode($stockCode = null)
    {
        // validation for constraint: string
        if (!is_null($stockCode) && !is_string($stockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockCode, true), gettype($stockCode)), __LINE__);
        }
        $this->stockCode = $stockCode;
        return $this;
    }
    /**
     * Get soldCount value
     * @return int|null
     */
    public function getSoldCount()
    {
        return $this->soldCount;
    }
    /**
     * Set soldCount value
     * @param int $soldCount
     * @return \StructType\VariantType
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        $this->soldCount = $soldCount;
        return $this;
    }
    /**
     * Get newCatalogId value
     * @return int|null
     */
    public function getNewCatalogId()
    {
        return $this->newCatalogId;
    }
    /**
     * Set newCatalogId value
     * @param int $newCatalogId
     * @return \StructType\VariantType
     */
    public function setNewCatalogId($newCatalogId = null)
    {
        // validation for constraint: int
        if (!is_null($newCatalogId) && !(is_int($newCatalogId) || ctype_digit($newCatalogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newCatalogId, true), gettype($newCatalogId)), __LINE__);
        }
        $this->newCatalogId = $newCatalogId;
        return $this;
    }
    /**
     * Get variantId value
     * @return int|null
     */
    public function getVariantId()
    {
        return $this->variantId;
    }
    /**
     * Set variantId value
     * @param int $variantId
     * @return \StructType\VariantType
     */
    public function setVariantId($variantId = null)
    {
        // validation for constraint: int
        if (!is_null($variantId) && !(is_int($variantId) || ctype_digit($variantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($variantId, true), gettype($variantId)), __LINE__);
        }
        $this->variantId = $variantId;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \StructType\VariantType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operation, true), gettype($operation)), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariantType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
