<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantSpecs StructType
 * @subpackage Structs
 */
class VariantSpecs extends AbstractStructBase
{
    /**
     * The variantSpec
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VariantSpecType[]
     */
    public $variantSpec;
    /**
     * Constructor method for variantSpecs
     * @uses VariantSpecs::setVariantSpec()
     * @param \StructType\VariantSpecType[] $variantSpec
     */
    public function __construct(array $variantSpec = array())
    {
        $this
            ->setVariantSpec($variantSpec);
    }
    /**
     * Get variantSpec value
     * @return \StructType\VariantSpecType[]|null
     */
    public function getVariantSpec()
    {
        return $this->variantSpec;
    }
    /**
     * This method is responsible for validating the values passed to the setVariantSpec method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariantSpec method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariantSpecForArrayConstraintsFromSetVariantSpec(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $variantSpecsVariantSpecItem) {
            // validation for constraint: itemType
            if (!$variantSpecsVariantSpecItem instanceof \StructType\VariantSpecType) {
                $invalidValues[] = is_object($variantSpecsVariantSpecItem) ? get_class($variantSpecsVariantSpecItem) : sprintf('%s(%s)', gettype($variantSpecsVariantSpecItem), var_export($variantSpecsVariantSpecItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variantSpec property can only contain items of type \StructType\VariantSpecType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variantSpec value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantSpecType[] $variantSpec
     * @return \StructType\VariantSpecs
     */
    public function setVariantSpec(array $variantSpec = array())
    {
        // validation for constraint: array
        if ('' !== ($variantSpecArrayErrorMessage = self::validateVariantSpecForArrayConstraintsFromSetVariantSpec($variantSpec))) {
            throw new \InvalidArgumentException($variantSpecArrayErrorMessage, __LINE__);
        }
        $this->variantSpec = $variantSpec;
        return $this;
    }
    /**
     * Add item to variantSpec value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantSpecType $item
     * @return \StructType\VariantSpecs
     */
    public function addToVariantSpec(\StructType\VariantSpecType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VariantSpecType) {
            throw new \InvalidArgumentException(sprintf('The variantSpec property can only contain items of type \StructType\VariantSpecType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variantSpec[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariantSpecs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
