<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantGroups StructType
 * @subpackage Structs
 */
class VariantGroups extends AbstractStructBase
{
    /**
     * The variantGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VariantGroupType[]
     */
    public $variantGroup;
    /**
     * Constructor method for variantGroups
     * @uses VariantGroups::setVariantGroup()
     * @param \StructType\VariantGroupType[] $variantGroup
     */
    public function __construct(array $variantGroup = array())
    {
        $this
            ->setVariantGroup($variantGroup);
    }
    /**
     * Get variantGroup value
     * @return \StructType\VariantGroupType[]|null
     */
    public function getVariantGroup()
    {
        return $this->variantGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setVariantGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariantGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariantGroupForArrayConstraintsFromSetVariantGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $variantGroupsVariantGroupItem) {
            // validation for constraint: itemType
            if (!$variantGroupsVariantGroupItem instanceof \StructType\VariantGroupType) {
                $invalidValues[] = is_object($variantGroupsVariantGroupItem) ? get_class($variantGroupsVariantGroupItem) : sprintf('%s(%s)', gettype($variantGroupsVariantGroupItem), var_export($variantGroupsVariantGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variantGroup property can only contain items of type \StructType\VariantGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variantGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantGroupType[] $variantGroup
     * @return \StructType\VariantGroups
     */
    public function setVariantGroup(array $variantGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($variantGroupArrayErrorMessage = self::validateVariantGroupForArrayConstraintsFromSetVariantGroup($variantGroup))) {
            throw new \InvalidArgumentException($variantGroupArrayErrorMessage, __LINE__);
        }
        $this->variantGroup = $variantGroup;
        return $this;
    }
    /**
     * Add item to variantGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantGroupType $item
     * @return \StructType\VariantGroups
     */
    public function addToVariantGroup(\StructType\VariantGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VariantGroupType) {
            throw new \InvalidArgumentException(sprintf('The variantGroup property can only contain items of type \StructType\VariantGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variantGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariantGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
