<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stockDetailType StructType
 * @subpackage Structs
 */
class StockDetailType extends AbstractStructBase
{
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The soldItemCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $soldItemCount;
    /**
     * The startPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $startPrice;
    /**
     * The buyNowPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $buyNowPrice;
    /**
     * Constructor method for stockDetailType
     * @uses StockDetailType::setItemId()
     * @uses StockDetailType::setProductId()
     * @uses StockDetailType::setFormat()
     * @uses StockDetailType::setAmount()
     * @uses StockDetailType::setSoldItemCount()
     * @uses StockDetailType::setStartPrice()
     * @uses StockDetailType::setBuyNowPrice()
     * @param string $itemId
     * @param int $productId
     * @param string $format
     * @param int $amount
     * @param int $soldItemCount
     * @param float $startPrice
     * @param float $buyNowPrice
     */
    public function __construct($itemId = null, $productId = null, $format = null, $amount = null, $soldItemCount = null, $startPrice = null, $buyNowPrice = null)
    {
        $this
            ->setItemId($itemId)
            ->setProductId($productId)
            ->setFormat($format)
            ->setAmount($amount)
            ->setSoldItemCount($soldItemCount)
            ->setStartPrice($startPrice)
            ->setBuyNowPrice($buyNowPrice);
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\StockDetailType
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\StockDetailType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\StockDetailType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\StockDetailType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get soldItemCount value
     * @return int|null
     */
    public function getSoldItemCount()
    {
        return $this->soldItemCount;
    }
    /**
     * Set soldItemCount value
     * @param int $soldItemCount
     * @return \StructType\StockDetailType
     */
    public function setSoldItemCount($soldItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldItemCount) && !(is_int($soldItemCount) || ctype_digit($soldItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldItemCount, true), gettype($soldItemCount)), __LINE__);
        }
        $this->soldItemCount = $soldItemCount;
        return $this;
    }
    /**
     * Get startPrice value
     * @return float|null
     */
    public function getStartPrice()
    {
        return $this->startPrice;
    }
    /**
     * Set startPrice value
     * @param float $startPrice
     * @return \StructType\StockDetailType
     */
    public function setStartPrice($startPrice = null)
    {
        // validation for constraint: float
        if (!is_null($startPrice) && !(is_float($startPrice) || is_numeric($startPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($startPrice, true), gettype($startPrice)), __LINE__);
        }
        $this->startPrice = $startPrice;
        return $this;
    }
    /**
     * Get buyNowPrice value
     * @return float|null
     */
    public function getBuyNowPrice()
    {
        return $this->buyNowPrice;
    }
    /**
     * Set buyNowPrice value
     * @param float $buyNowPrice
     * @return \StructType\StockDetailType
     */
    public function setBuyNowPrice($buyNowPrice = null)
    {
        // validation for constraint: float
        if (!is_null($buyNowPrice) && !(is_float($buyNowPrice) || is_numeric($buyNowPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buyNowPrice, true), gettype($buyNowPrice)), __LINE__);
        }
        $this->buyNowPrice = $buyNowPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
