<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for products StructType
 * @subpackage Structs
 */
class Products extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductDetailType[]
     */
    public $product;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $productId;
    /**
     * Constructor method for products
     * @uses Products::setProduct()
     * @uses Products::setProductId()
     * @param \StructType\ProductDetailType[] $product
     * @param int[] $productId
     */
    public function __construct(array $product = array(), array $productId = array())
    {
        $this
            ->setProduct($product)
            ->setProductId($productId);
    }
    /**
     * Get product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductDetailType[]|null
     */
    public function getProduct()
    {
        return isset($this->product) ? $this->product : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductForArrayConstraintsFromSetProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productsProductItem) {
            // validation for constraint: itemType
            if (!$productsProductItem instanceof \StructType\ProductDetailType) {
                $invalidValues[] = is_object($productsProductItem) ? get_class($productsProductItem) : sprintf('%s(%s)', gettype($productsProductItem), var_export($productsProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The product property can only contain items of type \StructType\ProductDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDetailType[] $product
     * @return \StructType\Products
     */
    public function setProduct(array $product = array())
    {
        // validation for constraint: array
        if ('' !== ($productArrayErrorMessage = self::validateProductForArrayConstraintsFromSetProduct($product))) {
            throw new \InvalidArgumentException($productArrayErrorMessage, __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->product);
        } else {
            $this->product = $product;
        }
        return $this;
    }
    /**
     * Add item to product value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDetailType $item
     * @return \StructType\Products
     */
    public function addToProduct(\StructType\ProductDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductDetailType) {
            throw new \InvalidArgumentException(sprintf('The product property can only contain items of type \StructType\ProductDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->product[] = $item;
        return $this;
    }
    /**
     * Get productId value
     * @return int[]|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * This method is responsible for validating the values passed to the setProductId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductIdForArrayConstraintsFromSetProductId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productsProductIdItem) {
            // validation for constraint: itemType
            if (!(is_int($productsProductIdItem) || ctype_digit($productsProductIdItem))) {
                $invalidValues[] = is_object($productsProductIdItem) ? get_class($productsProductIdItem) : sprintf('%s(%s)', gettype($productsProductIdItem), var_export($productsProductIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productId value
     * @throws \InvalidArgumentException
     * @param int[] $productId
     * @return \StructType\Products
     */
    public function setProductId(array $productId = array())
    {
        // validation for constraint: array
        if ('' !== ($productIdArrayErrorMessage = self::validateProductIdForArrayConstraintsFromSetProductId($productId))) {
            throw new \InvalidArgumentException($productIdArrayErrorMessage, __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Add item to productId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Products
     */
    public function addToProductId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The productId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Products
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
