<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productSuccessProcessType StructType
 * @subpackage Structs
 */
class ProductSuccessProcessType extends AbstractStructBase
{
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The changeStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $changeStatus;
    /**
     * Constructor method for productSuccessProcessType
     * @uses ProductSuccessProcessType::setProductId()
     * @uses ProductSuccessProcessType::setChangeStatus()
     * @param int $productId
     * @param string $changeStatus
     */
    public function __construct($productId = null, $changeStatus = null)
    {
        $this
            ->setProductId($productId)
            ->setChangeStatus($changeStatus);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductSuccessProcessType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get changeStatus value
     * @return string|null
     */
    public function getChangeStatus()
    {
        return $this->changeStatus;
    }
    /**
     * Set changeStatus value
     * @param string $changeStatus
     * @return \StructType\ProductSuccessProcessType
     */
    public function setChangeStatus($changeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($changeStatus) && !is_string($changeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeStatus, true), gettype($changeStatus)), __LINE__);
        }
        $this->changeStatus = $changeStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSuccessProcessType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
