<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productStatusType StructType
 * @subpackage Structs
 */
class ProductStatusType extends AbstractStructBase
{
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The currentStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currentStatus;
    /**
     * Constructor method for productStatusType
     * @uses ProductStatusType::setProductId()
     * @uses ProductStatusType::setItemId()
     * @uses ProductStatusType::setCurrentStatus()
     * @param int $productId
     * @param string $itemId
     * @param string $currentStatus
     */
    public function __construct($productId = null, $itemId = null, $currentStatus = null)
    {
        $this
            ->setProductId($productId)
            ->setItemId($itemId)
            ->setCurrentStatus($currentStatus);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductStatusType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ProductStatusType
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get currentStatus value
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return $this->currentStatus;
    }
    /**
     * Set currentStatus value
     * @param string $currentStatus
     * @return \StructType\ProductStatusType
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($currentStatus) && !is_string($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentStatus, true), gettype($currentStatus)), __LINE__);
        }
        $this->currentStatus = $currentStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductStatusType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
