<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceVariantResponse StructType
 * @subpackage Structs
 */
class ProductServiceVariantResponse extends BaseResponse
{
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The variantGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VariantGroups
     */
    public $variantGroups;
    /**
     * Constructor method for productServiceVariantResponse
     * @uses ProductServiceVariantResponse::setProductId()
     * @uses ProductServiceVariantResponse::setItemId()
     * @uses ProductServiceVariantResponse::setVariantGroups()
     * @param int $productId
     * @param string $itemId
     * @param \StructType\VariantGroups $variantGroups
     */
    public function __construct($productId = null, $itemId = null, \StructType\VariantGroups $variantGroups = null)
    {
        $this
            ->setProductId($productId)
            ->setItemId($itemId)
            ->setVariantGroups($variantGroups);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductServiceVariantResponse
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ProductServiceVariantResponse
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get variantGroups value
     * @return \StructType\VariantGroups|null
     */
    public function getVariantGroups()
    {
        return $this->variantGroups;
    }
    /**
     * Set variantGroups value
     * @param \StructType\VariantGroups $variantGroups
     * @return \StructType\ProductServiceVariantResponse
     */
    public function setVariantGroups(\StructType\VariantGroups $variantGroups = null)
    {
        $this->variantGroups = $variantGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceVariantResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
