<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceStatusResponse StructType
 * @subpackage Structs
 */
class ProductServiceStatusResponse extends BaseResponse
{
    /**
     * The productCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productCount;
    /**
     * The productStatusList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductStatusList
     */
    public $productStatusList;
    /**
     * Constructor method for productServiceStatusResponse
     * @uses ProductServiceStatusResponse::setProductCount()
     * @uses ProductServiceStatusResponse::setProductStatusList()
     * @param int $productCount
     * @param \StructType\ProductStatusList $productStatusList
     */
    public function __construct($productCount = null, \StructType\ProductStatusList $productStatusList = null)
    {
        $this
            ->setProductCount($productCount)
            ->setProductStatusList($productStatusList);
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\ProductServiceStatusResponse
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Get productStatusList value
     * @return \StructType\ProductStatusList|null
     */
    public function getProductStatusList()
    {
        return $this->productStatusList;
    }
    /**
     * Set productStatusList value
     * @param \StructType\ProductStatusList $productStatusList
     * @return \StructType\ProductServiceStatusResponse
     */
    public function setProductStatusList(\StructType\ProductStatusList $productStatusList = null)
    {
        $this->productStatusList = $productStatusList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
