<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceResponse StructType
 * @subpackage Structs
 */
class ProductServiceResponse extends BaseResponse
{
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The payRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $payRequired;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $result;
    /**
     * The descriptionFilterStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $descriptionFilterStatus;
    /**
     * The variantGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VariantGroups
     */
    public $variantGroups;
    /**
     * Constructor method for productServiceResponse
     * @uses ProductServiceResponse::setProductId()
     * @uses ProductServiceResponse::setPayRequired()
     * @uses ProductServiceResponse::setResult()
     * @uses ProductServiceResponse::setDescriptionFilterStatus()
     * @uses ProductServiceResponse::setVariantGroups()
     * @param int $productId
     * @param bool $payRequired
     * @param string $result
     * @param int $descriptionFilterStatus
     * @param \StructType\VariantGroups $variantGroups
     */
    public function __construct($productId = null, $payRequired = null, $result = null, $descriptionFilterStatus = null, \StructType\VariantGroups $variantGroups = null)
    {
        $this
            ->setProductId($productId)
            ->setPayRequired($payRequired)
            ->setResult($result)
            ->setDescriptionFilterStatus($descriptionFilterStatus)
            ->setVariantGroups($variantGroups);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductServiceResponse
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get payRequired value
     * @return bool|null
     */
    public function getPayRequired()
    {
        return $this->payRequired;
    }
    /**
     * Set payRequired value
     * @param bool $payRequired
     * @return \StructType\ProductServiceResponse
     */
    public function setPayRequired($payRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($payRequired) && !is_bool($payRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payRequired, true), gettype($payRequired)), __LINE__);
        }
        $this->payRequired = $payRequired;
        return $this;
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param string $result
     * @return \StructType\ProductServiceResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get descriptionFilterStatus value
     * @return int|null
     */
    public function getDescriptionFilterStatus()
    {
        return $this->descriptionFilterStatus;
    }
    /**
     * Set descriptionFilterStatus value
     * @param int $descriptionFilterStatus
     * @return \StructType\ProductServiceResponse
     */
    public function setDescriptionFilterStatus($descriptionFilterStatus = null)
    {
        // validation for constraint: int
        if (!is_null($descriptionFilterStatus) && !(is_int($descriptionFilterStatus) || ctype_digit($descriptionFilterStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($descriptionFilterStatus, true), gettype($descriptionFilterStatus)), __LINE__);
        }
        $this->descriptionFilterStatus = $descriptionFilterStatus;
        return $this;
    }
    /**
     * Get variantGroups value
     * @return \StructType\VariantGroups|null
     */
    public function getVariantGroups()
    {
        return $this->variantGroups;
    }
    /**
     * Set variantGroups value
     * @param \StructType\VariantGroups $variantGroups
     * @return \StructType\ProductServiceResponse
     */
    public function setVariantGroups(\StructType\VariantGroups $variantGroups = null)
    {
        $this->variantGroups = $variantGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
