<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServicePriceResponse StructType
 * @subpackage Structs
 */
class ProductServicePriceResponse extends BaseResponse
{
    /**
     * The paymentVoucher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentVoucher;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The payRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $payRequired;
    /**
     * The productCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productCount;
    /**
     * Constructor method for productServicePriceResponse
     * @uses ProductServicePriceResponse::setPaymentVoucher()
     * @uses ProductServicePriceResponse::setPrice()
     * @uses ProductServicePriceResponse::setMessage()
     * @uses ProductServicePriceResponse::setPayRequired()
     * @uses ProductServicePriceResponse::setProductCount()
     * @param string $paymentVoucher
     * @param float $price
     * @param string $message
     * @param bool $payRequired
     * @param int $productCount
     */
    public function __construct($paymentVoucher = null, $price = null, $message = null, $payRequired = null, $productCount = null)
    {
        $this
            ->setPaymentVoucher($paymentVoucher)
            ->setPrice($price)
            ->setMessage($message)
            ->setPayRequired($payRequired)
            ->setProductCount($productCount);
    }
    /**
     * Get paymentVoucher value
     * @return string|null
     */
    public function getPaymentVoucher()
    {
        return $this->paymentVoucher;
    }
    /**
     * Set paymentVoucher value
     * @param string $paymentVoucher
     * @return \StructType\ProductServicePriceResponse
     */
    public function setPaymentVoucher($paymentVoucher = null)
    {
        // validation for constraint: string
        if (!is_null($paymentVoucher) && !is_string($paymentVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentVoucher, true), gettype($paymentVoucher)), __LINE__);
        }
        $this->paymentVoucher = $paymentVoucher;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductServicePriceResponse
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ProductServicePriceResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get payRequired value
     * @return bool|null
     */
    public function getPayRequired()
    {
        return $this->payRequired;
    }
    /**
     * Set payRequired value
     * @param bool $payRequired
     * @return \StructType\ProductServicePriceResponse
     */
    public function setPayRequired($payRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($payRequired) && !is_bool($payRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payRequired, true), gettype($payRequired)), __LINE__);
        }
        $this->payRequired = $payRequired;
        return $this;
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\ProductServicePriceResponse
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServicePriceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
