<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceIdResponse StructType
 * @subpackage Structs
 */
class ProductServiceIdResponse extends BaseResponse
{
    /**
     * The productCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productCount;
    /**
     * The productIdList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductIdList
     */
    public $productIdList;
    /**
     * The voucher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $voucher;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $result;
    /**
     * Constructor method for productServiceIdResponse
     * @uses ProductServiceIdResponse::setProductCount()
     * @uses ProductServiceIdResponse::setProductIdList()
     * @uses ProductServiceIdResponse::setVoucher()
     * @uses ProductServiceIdResponse::setPrice()
     * @uses ProductServiceIdResponse::setResult()
     * @param int $productCount
     * @param \StructType\ProductIdList $productIdList
     * @param string $voucher
     * @param float $price
     * @param string $result
     */
    public function __construct($productCount = null, \StructType\ProductIdList $productIdList = null, $voucher = null, $price = null, $result = null)
    {
        $this
            ->setProductCount($productCount)
            ->setProductIdList($productIdList)
            ->setVoucher($voucher)
            ->setPrice($price)
            ->setResult($result);
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\ProductServiceIdResponse
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Get productIdList value
     * @return \StructType\ProductIdList|null
     */
    public function getProductIdList()
    {
        return $this->productIdList;
    }
    /**
     * Set productIdList value
     * @param \StructType\ProductIdList $productIdList
     * @return \StructType\ProductServiceIdResponse
     */
    public function setProductIdList(\StructType\ProductIdList $productIdList = null)
    {
        $this->productIdList = $productIdList;
        return $this;
    }
    /**
     * Get voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->voucher;
    }
    /**
     * Set voucher value
     * @param string $voucher
     * @return \StructType\ProductServiceIdResponse
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher, true), gettype($voucher)), __LINE__);
        }
        $this->voucher = $voucher;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductServiceIdResponse
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param string $result
     * @return \StructType\ProductServiceIdResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceIdResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
