<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productFinishReasonType StructType
 * @subpackage Structs
 */
class ProductFinishReasonType extends AbstractStructBase
{
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * The memberId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $memberId;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The reList
     * @var bool
     */
    public $reList;
    /**
     * Constructor method for productFinishReasonType
     * @uses ProductFinishReasonType::setProductId()
     * @uses ProductFinishReasonType::setEndDate()
     * @uses ProductFinishReasonType::setReason()
     * @uses ProductFinishReasonType::setMemberId()
     * @uses ProductFinishReasonType::setStartDate()
     * @uses ProductFinishReasonType::setReList()
     * @param int $productId
     * @param string $endDate
     * @param string $reason
     * @param int $memberId
     * @param string $startDate
     * @param bool $reList
     */
    public function __construct($productId = null, $endDate = null, $reason = null, $memberId = null, $startDate = null, $reList = null)
    {
        $this
            ->setProductId($productId)
            ->setEndDate($endDate)
            ->setReason($reason)
            ->setMemberId($memberId)
            ->setStartDate($startDate)
            ->setReList($reList);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductFinishReasonType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProductFinishReasonType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\ProductFinishReasonType
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get memberId value
     * @return int|null
     */
    public function getMemberId()
    {
        return $this->memberId;
    }
    /**
     * Set memberId value
     * @param int $memberId
     * @return \StructType\ProductFinishReasonType
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: int
        if (!is_null($memberId) && !(is_int($memberId) || ctype_digit($memberId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        $this->memberId = $memberId;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ProductFinishReasonType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get reList value
     * @return bool|null
     */
    public function getReList()
    {
        return $this->reList;
    }
    /**
     * Set reList value
     * @param bool $reList
     * @return \StructType\ProductFinishReasonType
     */
    public function setReList($reList = null)
    {
        // validation for constraint: boolean
        if (!is_null($reList) && !is_bool($reList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reList, true), gettype($reList)), __LINE__);
        }
        $this->reList = $reList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductFinishReasonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
