<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productDetailType StructType
 * @subpackage Structs
 */
class ProductDetailType extends AbstractStructBase
{
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductType
     */
    public $product;
    /**
     * The summary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductConcerningType
     */
    public $summary;
    /**
     * The ees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ees;
    /**
     * Constructor method for productDetailType
     * @uses ProductDetailType::setItemId()
     * @uses ProductDetailType::setProductId()
     * @uses ProductDetailType::setProduct()
     * @uses ProductDetailType::setSummary()
     * @uses ProductDetailType::setEes()
     * @param string $itemId
     * @param int $productId
     * @param \StructType\ProductType $product
     * @param \StructType\ProductConcerningType $summary
     * @param string $ees
     */
    public function __construct($itemId = null, $productId = null, \StructType\ProductType $product = null, \StructType\ProductConcerningType $summary = null, $ees = null)
    {
        $this
            ->setItemId($itemId)
            ->setProductId($productId)
            ->setProduct($product)
            ->setSummary($summary)
            ->setEes($ees);
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ProductDetailType
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductDetailType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\ProductType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ProductType $product
     * @return \StructType\ProductDetailType
     */
    public function setProduct(\StructType\ProductType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get summary value
     * @return \StructType\ProductConcerningType|null
     */
    public function getSummary()
    {
        return $this->summary;
    }
    /**
     * Set summary value
     * @param \StructType\ProductConcerningType $summary
     * @return \StructType\ProductDetailType
     */
    public function setSummary(\StructType\ProductConcerningType $summary = null)
    {
        $this->summary = $summary;
        return $this;
    }
    /**
     * Get ees value
     * @return string|null
     */
    public function getEes()
    {
        return $this->ees;
    }
    /**
     * Set ees value
     * @param string $ees
     * @return \StructType\ProductDetailType
     */
    public function setEes($ees = null)
    {
        // validation for constraint: string
        if (!is_null($ees) && !is_string($ees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ees, true), gettype($ees)), __LINE__);
        }
        $this->ees = $ees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
