<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for photos StructType
 * @subpackage Structs
 */
class Photos extends AbstractStructBase
{
    /**
     * The photo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhotoType[]
     */
    public $photo;
    /**
     * Constructor method for photos
     * @uses Photos::setPhoto()
     * @param \StructType\PhotoType[] $photo
     */
    public function __construct(array $photo = array())
    {
        $this
            ->setPhoto($photo);
    }
    /**
     * Get photo value
     * @return \StructType\PhotoType[]|null
     */
    public function getPhoto()
    {
        return $this->photo;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhotoForArrayConstraintsFromSetPhoto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $photosPhotoItem) {
            // validation for constraint: itemType
            if (!$photosPhotoItem instanceof \StructType\PhotoType) {
                $invalidValues[] = is_object($photosPhotoItem) ? get_class($photosPhotoItem) : sprintf('%s(%s)', gettype($photosPhotoItem), var_export($photosPhotoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The photo property can only contain items of type \StructType\PhotoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set photo value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoType[] $photo
     * @return \StructType\Photos
     */
    public function setPhoto(array $photo = array())
    {
        // validation for constraint: array
        if ('' !== ($photoArrayErrorMessage = self::validatePhotoForArrayConstraintsFromSetPhoto($photo))) {
            throw new \InvalidArgumentException($photoArrayErrorMessage, __LINE__);
        }
        $this->photo = $photo;
        return $this;
    }
    /**
     * Add item to photo value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoType $item
     * @return \StructType\Photos
     */
    public function addToPhoto(\StructType\PhotoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhotoType) {
            throw new \InvalidArgumentException(sprintf('The photo property can only contain items of type \StructType\PhotoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->photo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Photos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
